/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.lookup;

import java.util.Arrays;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.lookup.LookupRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.workspace.admin.lookup.LookupReplaceHelper;

public class LookupReplaceHelperTestCase
extends AbstractAppTest {
    private LookupReplaceHelper replacer;
    private Party pet;

    @Test
    public void testSpeciesReplace() {
        IMObjectBean bean = this.getBean((IMObject)this.pet);
        Lookup speciesA = this.createLookup("lookup.species", "A");
        Lookup breedA1 = this.createLookup("lookup.breed", "A1");
        Lookup breedA2 = this.createLookup("lookup.breed", "A2");
        this.addRelationship(speciesA, breedA1);
        this.addRelationship(speciesA, breedA2);
        Lookup speciesB = this.createLookup("lookup.species", "B");
        Lookup breedB1 = this.createLookup("lookup.breed", "B1");
        Lookup breedB2 = this.createLookup("lookup.breed", "B2");
        this.addRelationship(speciesB, breedB1);
        this.addRelationship(speciesB, breedB2);
        bean.setValue("species", (Object)speciesA.getCode());
        bean.setValue("breed", (Object)breedA1.getCode());
        bean.save();
        this.replacer.replace(speciesA, speciesB, false);
        this.pet = (Party)this.get((IMObject)this.pet);
        bean = this.getBean((IMObject)this.pet);
        speciesA = (Lookup)this.get((IMObject)speciesA);
        speciesB = (Lookup)this.get((IMObject)speciesB);
        breedA1 = (Lookup)this.get((IMObject)breedA1);
        breedA2 = (Lookup)this.get((IMObject)breedA2);
        breedB1 = (Lookup)this.get((IMObject)breedB1);
        breedB2 = (Lookup)this.get((IMObject)breedB2);
        this.save((IMObject)breedA1);
        Assert.assertEquals((Object)speciesB.getCode(), (Object)bean.getString("species"));
        Assert.assertEquals((Object)breedA1.getCode(), (Object)bean.getString("breed"));
        Assert.assertEquals((long)0L, (long)speciesA.getSourceLookupRelationships().size());
        Assert.assertEquals((long)4L, (long)speciesB.getSourceLookupRelationships().size());
        this.checkTarget(speciesB, breedA1);
        this.checkTarget(speciesB, breedA2);
        this.checkTarget(speciesB, breedB1);
        this.checkTarget(speciesB, breedB2);
    }

    @Test
    public void testSpeciesReplaceWithDelete() {
        IMObjectBean bean = this.getBean((IMObject)this.pet);
        Lookup speciesA = this.createLookup("lookup.species", "A");
        Lookup breedA1 = this.createLookup("lookup.breed", "A1");
        Lookup breedA2 = this.createLookup("lookup.breed", "A2");
        this.addRelationship(speciesA, breedA1);
        this.addRelationship(speciesA, breedA2);
        Lookup speciesB = this.createLookup("lookup.species", "B");
        Lookup breedB1 = this.createLookup("lookup.breed", "B1");
        Lookup breedB2 = this.createLookup("lookup.breed", "B2");
        this.addRelationship(speciesB, breedB1);
        this.addRelationship(speciesB, breedB2);
        bean.setValue("species", (Object)speciesA.getCode());
        bean.setValue("breed", (Object)breedA1.getCode());
        bean.save();
        this.replacer.replace(speciesA, speciesB, true);
        this.pet = (Party)this.get((IMObject)this.pet);
        bean = this.getBean((IMObject)this.pet);
        speciesA = (Lookup)this.get((IMObject)speciesA);
        speciesB = (Lookup)this.get((IMObject)speciesB);
        Assert.assertNull((Object)speciesA);
        breedA1 = (Lookup)this.get((IMObject)breedA1);
        breedA2 = (Lookup)this.get((IMObject)breedA2);
        breedB1 = (Lookup)this.get((IMObject)breedB1);
        breedB2 = (Lookup)this.get((IMObject)breedB2);
        this.save((IMObject)breedA1);
        Assert.assertEquals((Object)speciesB.getCode(), (Object)bean.getString("species"));
        Assert.assertEquals((Object)breedA1.getCode(), (Object)bean.getString("breed"));
        Assert.assertEquals((long)4L, (long)speciesB.getSourceLookupRelationships().size());
        this.checkTarget(speciesB, breedA1);
        this.checkTarget(speciesB, breedA2);
        this.checkTarget(speciesB, breedB1);
        this.checkTarget(speciesB, breedB2);
    }

    @Test
    public void testBreedReplacementForSameSpecies() {
        IMObjectBean bean = this.getBean((IMObject)this.pet);
        Lookup species = this.createLookup("lookup.species", "A");
        Lookup breed1 = this.createLookup("lookup.breed", "A1");
        Lookup breed2 = this.createLookup("lookup.breed", "A2");
        this.addRelationship(species, breed1);
        this.addRelationship(species, breed2);
        bean.setValue("species", (Object)species.getCode());
        bean.setValue("breed", (Object)breed1.getCode());
        bean.save();
        this.replacer.replace(breed1, breed2, false);
        this.pet = (Party)this.get((IMObject)this.pet);
        bean = this.getBean((IMObject)this.pet);
        breed1 = (Lookup)this.get((IMObject)breed1);
        breed2 = (Lookup)this.get((IMObject)breed2);
        this.validate((IMObject)breed1);
        this.validate((IMObject)breed2);
        Assert.assertEquals((Object)species.getCode(), (Object)bean.getString("species"));
        Assert.assertEquals((Object)breed2.getCode(), (Object)bean.getString("breed"));
        Assert.assertEquals((long)2L, (long)species.getSourceLookupRelationships().size());
        this.checkTarget(species, breed1);
        this.checkTarget(species, breed2);
    }

    @Test
    public void testBreedReplacementForSameSpeciesWithDelete() {
        IMObjectBean bean = this.getBean((IMObject)this.pet);
        Lookup species = this.createLookup("lookup.species", "A");
        Lookup breed1 = this.createLookup("lookup.breed", "A1");
        Lookup breed2 = this.createLookup("lookup.breed", "A2");
        this.addRelationship(species, breed1);
        this.addRelationship(species, breed2);
        bean.setValue("species", (Object)species.getCode());
        bean.setValue("breed", (Object)breed1.getCode());
        bean.save();
        this.replacer.replace(breed1, breed2, true);
        this.pet = (Party)this.get((IMObject)this.pet);
        bean = this.getBean((IMObject)this.pet);
        Assert.assertNull((Object)this.get((IMObject)breed1));
        species = (Lookup)this.get((IMObject)species);
        breed2 = (Lookup)this.get((IMObject)breed2);
        this.validate((IMObject)breed2);
        Assert.assertEquals((Object)species.getCode(), (Object)bean.getString("species"));
        Assert.assertEquals((Object)breed2.getCode(), (Object)bean.getString("breed"));
        Assert.assertEquals((long)1L, (long)species.getSourceLookupRelationships().size());
        this.checkTarget(species, breed2);
    }

    @Test
    public void testBreedReplacementForDifferentSpecies() {
        IMObjectBean bean = this.getBean((IMObject)this.pet);
        Lookup speciesA = this.createLookup("lookup.species", "A");
        Lookup breedA = this.createLookup("lookup.breed", "A1");
        this.addRelationship(speciesA, breedA);
        Lookup speciesB = this.createLookup("lookup.species", "B");
        Lookup breedB = this.createLookup("lookup.breed", "B1");
        this.addRelationship(speciesB, breedB);
        bean.setValue("species", (Object)speciesA.getCode());
        bean.setValue("breed", (Object)breedA.getCode());
        bean.save();
        try {
            this.replacer.replace(breedA, breedB, false);
            Assert.fail((String)"Expected ValidationException");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    @Before
    public void setUp() {
        super.setUp();
        this.replacer = new LookupReplaceHelper();
        this.pet = TestHelper.createPatient();
    }

    private void checkTarget(Lookup source, Lookup target) {
        boolean found = false;
        for (LookupRelationship relationship : source.getSourceLookupRelationships()) {
            if (!Objects.equals(target.getObjectReference(), relationship.getTarget())) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    private void addRelationship(Lookup species, Lookup breed) {
        LookupRelationship relationship = (LookupRelationship)this.create("lookupRelationship.speciesBreed", LookupRelationship.class);
        relationship.setSource(species.getObjectReference());
        relationship.setTarget(breed.getObjectReference());
        species.addLookupRelationship(relationship);
        breed.addLookupRelationship(relationship);
        this.save(Arrays.asList(species, breed));
    }

    private void validate(IMObject object) {
        IArchetypeService service = this.getArchetypeService();
        service.validateObject(object);
    }

    private Lookup createLookup(String shortName, String code) {
        return TestHelper.getLookup((String)shortName, (String)(code + System.currentTimeMillis()));
    }
}

