/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.admin.laboratory;

import org.junit.Test;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditorTest;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.workspace.admin.laboratory.HL7LaboratoryTestEditor;
import org.springframework.beans.factory.annotation.Autowired;

public class HL7LaboratoryTestEditorTestCase
extends AbstractIMObjectEditorTest<HL7LaboratoryTestEditor> {
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;

    public HL7LaboratoryTestEditorTestCase() {
        super(HL7LaboratoryTestEditor.class, "entity.laboratoryTestHL7");
    }

    @Test
    public void testValidateInvestigationType() {
        Entity test = (Entity)this.laboratoryFactory.newHL7Test().code("AB1234").build(false);
        HL7LaboratoryTestEditor editor = (HL7LaboratoryTestEditor)this.newEditor((IMObject)test);
        editor.getComponent();
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)"Investigation Type is required");
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType();
        editor.setInvestigationType(investigationType1);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)(investigationType1.getName() + " cannot be assigned to this Test. It is not managed by an HL7 Laboratory."));
        Entity laboratory2 = this.laboratoryFactory.createLaboratory();
        Entity investigationType2 = this.laboratoryFactory.createInvestigationType(laboratory2);
        editor.setInvestigationType(investigationType2);
        EditorTestHelper.assertInvalid((Modifiable)editor, (String)(investigationType2.getName() + " cannot be assigned to this Test. It is not managed by an HL7 Laboratory."));
        Entity laboratory3 = this.laboratoryFactory.createHL7Laboratory(this.practiceFactory.createLocation(), this.userFactory.createUser());
        Entity investigationType3 = this.laboratoryFactory.createInvestigationType(laboratory3);
        editor.setInvestigationType(investigationType3);
        EditorTestHelper.assertValid((Modifiable)editor);
        Entity laboratory4 = this.laboratoryFactory.createHL7LaboratoryGroup(new Entity[]{laboratory3});
        Entity investigationType4 = this.laboratoryFactory.createInvestigationType(laboratory4);
        editor.setInvestigationType(investigationType4);
        EditorTestHelper.assertValid((Modifiable)editor);
    }
}

