/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.EmailDocumentTemplateEditor;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class EmailDocumentTemplateEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestDocumentFactory documentFactory;

    @Test
    public void testFactory() {
        Entity template1 = (Entity)this.create("entity.documentTemplateEmailUser", Entity.class);
        IMObjectEditor editor1 = this.factory.create((IMObject)template1, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor1 instanceof EmailDocumentTemplateEditor));
        Entity template2 = (Entity)this.create("entity.documentTemplateEmailSystem", Entity.class);
        IMObjectEditor editor2 = this.factory.create((IMObject)template2, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor2 instanceof EmailDocumentTemplateEditor));
    }

    @Test
    public void testNewInstance() {
        Entity template = (Entity)this.create("entity.documentTemplateEmailUser", Entity.class);
        EmailDocumentTemplateEditor editor = this.createEditor(template);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof EmailDocumentTemplateEditor));
    }

    @Test
    public void testDelete() {
        Entity template = (Entity)this.create("entity.documentTemplateEmailUser", Entity.class);
        EmailDocumentTemplateEditor editor1 = this.createEditor(template);
        editor1.getProperty("name").setValue((Object)"Z Test template");
        editor1.getProperty("subject").setValue((Object)"test email");
        editor1.getProperty("contentType").setValue((Object)EmailTemplate.ContentType.DOCUMENT.name());
        Document document = this.documentFactory.createJRXML();
        editor1.onUpload(document);
        DocumentAct act = editor1.getDocumentAct();
        Assert.assertNotNull((Object)act);
        Assert.assertEquals((Object)document.getObjectReference(), (Object)act.getDocument());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        Assert.assertNotNull((Object)this.get((IMObject)act));
        Assert.assertNotNull((Object)this.get((IMObject)document));
        Document attachmentContent = this.documentFactory.createPDF("Patient Handout.pdf");
        Entity attachment = (Entity)((TestDocumentTemplateBuilder)this.documentFactory.newTemplate().type("act.patientDocumentForm").document(attachmentContent)).build();
        this.documentFactory.updateEmailTemplate(template).addAttachments(new Entity[]{attachment}).build();
        final EmailDocumentTemplateEditor editor2 = this.createEditor(template);
        TransactionTemplate txn = new TransactionTemplate(ServiceHelper.getTransactionManager());
        txn.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                editor2.delete();
            }
        });
        Assert.assertNull((Object)this.get((IMObject)template));
        Assert.assertNull((Object)this.get((IMObject)act));
        Assert.assertNull((Object)this.get((IMObject)document));
        Assert.assertNotNull((Object)this.get((IMObject)attachmentContent));
        Assert.assertNotNull((Object)this.get((IMObject)attachment));
    }

    @Test
    public void testValidateDefaultEmailAddress() {
        Entity template1 = (Entity)this.documentFactory.newEmailTemplate().subject("subject").defaultEmailAddress("foo@bar.com").build(false);
        EmailDocumentTemplateEditor editor1 = this.createEditor(template1);
        EditorTestHelper.assertValid((Modifiable)editor1);
        Entity template2 = (Entity)this.documentFactory.newEmailTemplate().subject("subject").defaultEmailAddress("\"name\" <foo@bar.com>").build(false);
        EmailDocumentTemplateEditor editor2 = this.createEditor(template2);
        EditorTestHelper.assertValid((Modifiable)editor2);
        Entity template3 = (Entity)this.documentFactory.newEmailTemplate().subject("subject").build(false);
        EmailDocumentTemplateEditor editor3 = this.createEditor(template3);
        EditorTestHelper.assertValid((Modifiable)editor3);
        Entity test4 = (Entity)this.documentFactory.newEmailTemplate().subject("subject").defaultEmailAddress("@bar.com").build(false);
        EmailDocumentTemplateEditor editor4 = this.createEditor(test4);
        EditorTestHelper.assertInvalid((Modifiable)editor4, (String)"Missing local name");
        Entity test5 = (Entity)this.documentFactory.newEmailTemplate().subject("subject").defaultEmailAddress("\"name <foo@bar.com>").build(false);
        EmailDocumentTemplateEditor editor5 = this.createEditor(test5);
        EditorTestHelper.assertInvalid((Modifiable)editor5, (String)"Missing '\"'");
    }

    private EmailDocumentTemplateEditor createEditor(Entity template) {
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        return new EmailDocumentTemplateEditor(template, null, (LayoutContext)layoutContext);
    }
}

