/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.DocumentTemplateEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DocumentTemplateEditorTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestLookupFactory lookupFactory;

    @Test
    public void testFactory() {
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        IMObjectEditor editor = this.factory.create((IMObject)template, (LayoutContext)new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null)));
        Assert.assertTrue((boolean)(editor instanceof DocumentTemplateEditor));
    }

    @Test
    public void testNewInstance() {
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        DocumentTemplateEditor editor = this.createEditor(template);
        IMObjectEditor newInstance = editor.newInstance();
        Assert.assertTrue((boolean)(newInstance instanceof DocumentTemplateEditor));
    }

    @Test
    public void testUpload() {
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        DocumentTemplateEditor editor = this.createEditor(template);
        editor.getProperty("name").setValue((Object)"Z Test template");
        Document document1 = this.documentFactory.createJRXML();
        editor.onUpload(document1);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        Document original = this.checkDocument(template, document1);
        Document document2 = this.documentFactory.createDocument("/sqlreport.jrxml");
        editor.onUpload(document2);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkDocument(template, document2);
        Assert.assertNull((Object)this.get((IMObject)original));
    }

    @Test
    public void testUploadTwice() {
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        DocumentTemplateEditor editor = this.createEditor(template);
        editor.getProperty("name").setValue((Object)"Z Test template");
        Document document1 = this.documentFactory.createJRXML();
        editor.onUpload(document1);
        document1 = (Document)this.get((IMObject)document1);
        Assert.assertNotNull((Object)document1);
        Document document2 = this.documentFactory.createDocument("/sqlreport.jrxml");
        editor.onUpload(document2);
        Assert.assertNotNull((Object)this.get((IMObject)document1));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        this.checkDocument(template, document2);
        Assert.assertNull((Object)this.get((IMObject)document1));
    }

    @Test
    public void testReplaceDocument() {
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        DocumentTemplateEditor editor1 = this.createEditor(template);
        editor1.getProperty("name").setValue((Object)"Z Test template");
        Document document1 = this.documentFactory.createJRXML();
        editor1.onUpload(document1);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        Document actual1 = this.checkDocument(template, document1);
        DocumentTemplateEditor editor2 = this.createEditor(template);
        Document document2 = this.documentFactory.createDocument("/sqlreport.jrxml");
        editor2.onUpload(document2);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor2));
        Document actual2 = this.checkDocument(template, document2);
        Assert.assertNull((Object)this.get((IMObject)actual1));
        DocumentTemplateEditor editor3 = this.createEditor(template);
        Document document3 = this.documentFactory.createJRXML();
        editor3.onUpload(document3);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor3));
        this.checkDocument(template, document3);
        Assert.assertNull((Object)this.get((IMObject)actual2));
    }

    @Test
    public void testDelete() {
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        DocumentTemplateEditor editor1 = this.createEditor(template);
        editor1.getProperty("name").setValue((Object)"Z Test template");
        Document document = this.documentFactory.createJRXML();
        editor1.onUpload(document);
        DocumentAct act = editor1.getDocumentAct();
        Assert.assertNotNull((Object)act);
        Assert.assertEquals((Object)document.getObjectReference(), (Object)act.getDocument());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        Assert.assertNotNull((Object)this.get((IMObject)act));
        Assert.assertNotNull((Object)this.get((IMObject)document));
        Document emailTemplateContent = (Document)((TestDocumentBuilder)this.documentFactory.newDocument().name("test.jrxml")).mimeType("text/xml").content("<jrxml/>").build();
        Entity emailTemplate = (Entity)this.documentFactory.newEmailTemplate().subject("subject").document(emailTemplateContent).build();
        this.documentFactory.updateTemplate(template).emailTemplate(emailTemplate).build();
        final DocumentTemplateEditor editor2 = this.createEditor(template);
        TransactionTemplate txn = new TransactionTemplate(ServiceHelper.getTransactionManager());
        txn.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                editor2.delete();
            }
        });
        Assert.assertNull((Object)this.get((IMObject)template));
        Assert.assertNull((Object)this.get((IMObject)act));
        Assert.assertNull((Object)this.get((IMObject)document));
        Assert.assertNotNull((Object)this.get((IMObject)emailTemplate));
        Assert.assertNotNull((Object)this.get((IMObject)emailTemplateContent));
    }

    @Test
    public void testSupportedContent() {
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        DocumentTemplateEditor editor = this.createEditor(template);
        Assert.assertNull((Object)editor.getTypeCode());
        this.checkDefaultContent(editor, null);
        this.checkFormContent(editor, "act.customerDocumentForm");
        this.checkFormContent(editor, "act.patientDocumentForm");
        this.checkFormContent(editor, "act.supplierDocumentForm");
        this.checkLetterContent(editor, "act.customerDocumentLetter");
        this.checkLetterContent(editor, "act.patientDocumentLetter");
        this.checkLetterContent(editor, "act.supplierDocumentLetter");
        this.checkReportContent(editor, "REPORT");
        this.checkReportContent(editor, "SUBREPORT");
        this.checkDefaultContent(editor, "act.customerAppointment");
        this.checkDefaultContent(editor, "act.customerAccountChargesInvoice");
    }

    @Test
    public void testOrientation() {
        Entity template = (Entity)this.create("entity.documentTemplate", Entity.class);
        DocumentTemplateEditor editor1 = this.createEditor(template);
        editor1.getProperty("name").setValue((Object)"Z Test template");
        Document document = this.documentFactory.createJRXML();
        editor1.onUpload(document);
        Assert.assertEquals((Object)"PORTRAIT", (Object)editor1.getProperty("orientation").getString());
        editor1.getProperty("orientation").setValue(null);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor1));
        Entity reloaded = (Entity)this.get((IMObject)template);
        DocumentTemplate template1 = new DocumentTemplate(reloaded, (ArchetypeService)this.getArchetypeService());
        Assert.assertNull((Object)template1.getOrientation());
        DocumentTemplateEditor editor2 = this.createEditor(reloaded);
        Assert.assertNull((Object)editor2.getProperty("orientation").getString());
    }

    protected DocumentTemplateEditor createEditor(Entity template) {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        DocumentTemplateEditor editor = new DocumentTemplateEditor(template, null, (LayoutContext)context);
        editor.getComponent();
        return editor;
    }

    private void checkDefaultContent(DocumentTemplateEditor editor, String type) {
        this.setTypeCode(editor, type);
        this.checkJasperReportsContent(editor);
        this.checkMergeableContent(editor, true);
        this.checkPDFContent(editor, false);
    }

    private void setTypeCode(DocumentTemplateEditor editor, String type) {
        if (type != null) {
            this.lookupFactory.getLookup("lookup.documentTemplateType", type);
        }
        editor.setTypeCode(type);
    }

    private void checkFormContent(DocumentTemplateEditor editor, String archetype) {
        this.setTypeCode(editor, archetype);
        this.checkMergeableContent(editor, true);
        this.checkJasperReportsContent(editor);
        this.checkPDFContent(editor, true);
    }

    private void checkLetterContent(DocumentTemplateEditor editor, String archetype) {
        this.setTypeCode(editor, archetype);
        this.checkMergeableContent(editor, true);
        this.checkJasperReportsContent(editor);
        this.checkPDFContent(editor, false);
    }

    private void checkReportContent(DocumentTemplateEditor editor, String type) {
        this.setTypeCode(editor, type);
        this.checkJasperReportsContent(editor);
        this.checkMergeableContent(editor, false);
        this.checkPDFContent(editor, false);
    }

    private void checkMergeableContent(DocumentTemplateEditor editor, boolean supported) {
        Assert.assertEquals((Object)supported, (Object)editor.isContentSupported("test.doc", "application/msword"));
        Assert.assertEquals((Object)supported, (Object)editor.isContentSupported("test.doc", "application/octet-stream"));
        Assert.assertEquals((Object)supported, (Object)editor.isContentSupported("test.odt", "application/vnd.oasis.opendocument.text"));
        Assert.assertEquals((Object)supported, (Object)editor.isContentSupported("test.odt", "application/octet-stream"));
        Assert.assertEquals((Object)supported, (Object)editor.isContentSupported("test.rtf", "text/rtf"));
        Assert.assertEquals((Object)supported, (Object)editor.isContentSupported("test.rtf", "application/octet-stream"));
        Assert.assertFalse((boolean)editor.isContentSupported("test.docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"));
        Assert.assertFalse((boolean)editor.isContentSupported("test.docx", "application/octet-stream"));
        Assert.assertFalse((boolean)editor.isContentSupported("test.gif", "image/gif"));
        Assert.assertFalse((boolean)editor.isContentSupported("test.jpg", "image/jpeg"));
        Assert.assertFalse((boolean)editor.isContentSupported("test.png", "image/png"));
    }

    private void checkJasperReportsContent(DocumentTemplateEditor editor) {
        Assert.assertTrue((boolean)editor.isContentSupported("test.jrxml", "text/xml"));
        Assert.assertTrue((boolean)editor.isContentSupported("test.jrxml", "application/octet-stream"));
    }

    private void checkPDFContent(DocumentTemplateEditor editor, boolean supported) {
        Assert.assertEquals((Object)supported, (Object)editor.isContentSupported("test.pdf", "application/pdf"));
        Assert.assertEquals((Object)supported, (Object)editor.isContentSupported("test.pdf", "application/octet-stream"));
    }

    private Document checkDocument(Entity template, Document expected) {
        TemplateHelper helper = new TemplateHelper((ArchetypeService)ServiceHelper.getArchetypeService());
        DocumentAct act = helper.getDocumentAct(template);
        Assert.assertNotNull((Object)act);
        Assert.assertEquals((Object)expected.getName(), (Object)act.getFileName());
        Assert.assertEquals((Object)expected.getMimeType(), (Object)act.getMimeType());
        Document document = (Document)this.get(act.getDocument());
        this.documentFactory.newVerifier(expected).verify(document);
        return document;
    }
}

