/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.reporting.charge;

import org.openvpms.archetype.rules.act.ActStatus;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActStatuses;


/**
 * Query for incomplete charges. i.e. invoices, credit and counter-sale acts that are IN_PROGRESS, COMPLETE, or ON_HOLD.
 *
 * @author Tim Anderson
 */
public class IncompleteChargesQuery extends AbstractChargesQuery {

    /**
     * The act statuses, excluding POSTED.
     */
    private static final ActStatuses STATUSES = new ActStatuses(CustomerAccountArchetypes.INVOICE, ActStatus.POSTED);

    /**
     * The default sort constraint.
     */
    private static final SortConstraint[] DEFAULT_SORT = {new NodeSortConstraint("customer")};

    /**
     * Constructs an {@link IncompleteChargesQuery}.
     *
     * @param context the context
     */
    public IncompleteChargesQuery(LayoutContext context) {
        super(STATUSES, context.getContext().getLocation(), false, false, context);
        setDefaultSortConstraint(DEFAULT_SORT);
        setAuto(true);
    }
}