/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.reporting.charge;

import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActStatuses;

/**
 * Query charges by type, customer name, status, date, amount and location.
 *
 * @author Tim Anderson
 */
public class ChargesQuery extends AbstractChargesQuery {

    /**
     * The act statuses.
     */
    private static final ActStatuses STATUSES;

    static {
        STATUSES = new ActStatuses(CustomerAccountArchetypes.INVOICE);
        STATUSES.setDefault((String) null);
    }

    /**
     * Constructs a {@link ChargesQuery}.
     *
     * @param context the layout context
     */
    public ChargesQuery(LayoutContext context) {
        super(STATUSES, null, true, true, context);
    }
}