/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.reporting;

import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.PracticeMailContext;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.AbstractWorkspaces;
import org.openvpms.web.workspace.reporting.charge.ChargesWorkspace;
import org.openvpms.web.workspace.reporting.deposit.DepositWorkspace;
import org.openvpms.web.workspace.reporting.insurance.InsuranceWorkspace;
import org.openvpms.web.workspace.reporting.payment.PaymentsWorkspace;
import org.openvpms.web.workspace.reporting.reminder.ReminderWorkspace;
import org.openvpms.web.workspace.reporting.report.ReportingWorkspace;
import org.openvpms.web.workspace.reporting.statement.StatementWorkspace;
import org.openvpms.web.workspace.reporting.till.TillWorkspace;


/**
 * Reporting workspaces.
 *
 * @author Tim Anderson
 */
public class ReportingWorkspaces extends AbstractWorkspaces {

    /**
     * Constructs a {@code ReportingWorkspaces}.
     *
     * @param context     the context
     * @param preferences the preferences
     */
    public ReportingWorkspaces(Context context, Preferences preferences) {
        super("reporting");

        MailContext mailContext = new PracticeMailContext(context);
        addWorkspace(new TillWorkspace(context, mailContext));
        addWorkspace(new DepositWorkspace(context, mailContext));
        addWorkspace(new StatementWorkspace(context));
        addWorkspace(new ChargesWorkspace(context, mailContext, preferences));
        addWorkspace(new PaymentsWorkspace(context, mailContext, preferences));
        addWorkspace(new ReminderWorkspace(context, mailContext, preferences));
        addWorkspace(new InsuranceWorkspace(context, mailContext));
        addWorkspace(new ReportingWorkspace(context, mailContext));
    }
}
