/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.customer.payment;

import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;

/**
 * Layout strategy for <em>act.customerAccountPaymentEFT</em>, <em>act.customerAccountRefundEFT</em>,
 * <em>act.customerAccountPaymentPP</em> and <em>act.customerAccountRefundPP</em> acts.
 *
 * @author Tim Anderson
 */
public class TransactionPaymentLayoutStrategy extends AbstractLayoutStrategy {

    /**
     * Constructs an {@link TransactionPaymentLayoutStrategy}.
     */
    public TransactionPaymentLayoutStrategy() {
        super(ArchetypeNodes.all().excludeIfEmpty("transactions"));
    }
}
