/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.customer.payment;

import nextapp.echo2.app.table.TableColumn;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DefaultDescriptorTableModel;

/**
 * Table model for <em>act.customerAccountPayment*</em> items.
 *
 * @author Tim Anderson
 */
public class PaymentItemTableModel extends DefaultDescriptorTableModel<FinancialAct> {

    /**
     * Constructs a {@link PaymentItemTableModel}.
     *
     * @param archetypes the archetypes. May contain wildcards
     * @param context    the layout context
     */
    public PaymentItemTableModel(String[] archetypes, LayoutContext context) {
        super(archetypes, context, "amount");
    }

    /**
     * Returns the value found at the given coordinate within the table.
     *
     * @param object the object
     * @param column the table column
     * @param row    the table row
     */
    @Override
    protected Object getValue(FinancialAct object, TableColumn column, int row) {
        Object result = null;
        if (column.getModelIndex() == ARCHETYPE_INDEX && object.isA(CustomerAccountArchetypes.PAYMENT_PP,
                                                                    CustomerAccountArchetypes.REFUND_PP)) {
            result = getPaymentProcessorName(object);
        }
        if (result == null) {
            result = super.getValue(object, column, row);
        }
        return result;
    }

    /**
     * Returns the name of the payment processor associated with a payment item.
     *
     * @param object the payment item
     * @return the payment processor name. May be {@code null}
     */
    private String getPaymentProcessorName(FinancialAct object) {
        IMObjectBean bean = getBean(object);
        IMObject paymentProcessor = getLayoutContext().getCache().get(bean.getTargetRef("paymentProcessor"));
        return (paymentProcessor != null) ? paymentProcessor.getName() : null;
    }
}