/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2025 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.customer;

import org.openvpms.archetype.rules.party.ContactArchetypes;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextMailContext;
import org.openvpms.web.echo.help.HelpContext;

/**
 * Customer mail context that uses the BILLING purpose to select the 'From' email contact.
 *
 * @author Tim Anderson
 */
public class BillingCustomerMailContext extends CustomerMailContext{

    /**
     * Constructs a {@link CustomerMailContext}.
     *
     * @param context the context
     */
    public BillingCustomerMailContext(Context context) {
        super(context, ContactArchetypes.BILLING_PURPOSE, true);
    }

    /**
     * Constructs a {@link ContextMailContext}.
     *
     * @param context     the context
     */
    public BillingCustomerMailContext(Context context, HelpContext help) {
        super(context, ContactArchetypes.BILLING_PURPOSE, true, help);
    }
}
