/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2013 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.workspace.admin.style;

import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.style.StyleSheets;
import org.openvpms.web.echo.text.TextField;

import java.awt.Dimension;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;


/**
 * Style workspace helper methods.
 *
 * @author Tim Anderson
 */
public class StyleHelper {

    /**
     * Indicates that the properties apply to all screen resolutions.
     */
    public static final Dimension ANY_RESOLUTION = new Dimension(-1, -1);

    /**
     * The default screen resolution.
     */
    public static final Dimension DEFAULT_RESOLUTION = new Dimension(1024, 768);

    /**
     * Returns properties for the specified resolution.
     *
     * @param stylesheets the style sheets
     * @param size        the resolution to return properties for. If {@link #ANY_RESOLUTION}, returns the default
     *                    properties
     * @param evaluate    if <tt>true</tt> evaluate properties
     * @return the properties for the resolution, ordered on name
     */
    public static Map<String, String> getProperties(StyleSheets stylesheets, Dimension size, boolean evaluate) {
        Map<String, String> properties = Collections.emptyMap();
        if (size != null) {
            if (evaluate || !ANY_RESOLUTION.equals(size)) {
                properties = stylesheets.getProperties(size.width, size.height, evaluate);
            } else {
                properties = stylesheets.getDefaultProperties();
            }
            properties = new TreeMap<String, String>(properties);
        }
        return properties;
    }

    /**
     * Helper to add a label and text field for a property to a grid.
     *
     * @param grid     the grid
     * @param property the property to add
     */
    public static void addProperty(Grid grid, Property property) {
        Label name = LabelFactory.create();
        name.setText(property.getDisplayName());
        int length = property.getMaxLength() != -1 ? property.getMaxLength() : 40;
        TextField field = BoundTextComponentFactory.create(property, length);
        grid.add(name);
        grid.add(field);
    }


}
