/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.worklist.TaskTypeQuery;

public class TaskTypeParticipationEditor
extends ParticipationEditor<Entity> {
    private final IArchetypeService service;
    private Entity workList;

    public TaskTypeParticipationEditor(Participation participation, Act parent, LayoutContext context) {
        super(participation, parent, context);
        if (!participation.isA("participation.taskType")) {
            throw new IllegalArgumentException("Invalid participation type:" + participation.getArchetype());
        }
        this.service = ServiceHelper.getArchetypeService();
    }

    public void setWorkList(Entity workList) {
        this.workList = workList;
        if (workList != null) {
            Reference taskTypeRef = this.getEntityRef();
            if (taskTypeRef == null || !this.hasTaskType(workList, taskTypeRef)) {
                Entity taskType = this.getDefaultTaskType(workList);
                this.setEntity(taskType);
            }
        } else {
            this.setEntity(null);
        }
    }

    protected IMObjectReferenceEditor<Entity> createEntityEditor(Property property) {
        return new AbstractIMObjectReferenceEditor<Entity>(property, this.getParent(), this.getLayoutContext()){

            protected Query<Entity> createQuery(String name) {
                Entity entity;
                TaskTypeQuery query = new TaskTypeQuery(TaskTypeParticipationEditor.this.workList, this.getLayoutContext().getContext());
                if (!(name == null || (entity = TaskTypeParticipationEditor.this.getEntity()) != null && StringUtils.equals((CharSequence)entity.getName(), (CharSequence)name))) {
                    query.setValue(name);
                }
                return query;
            }
        };
    }

    private boolean hasTaskType(Entity workList, Reference taskType) {
        IMObjectBean bean = this.service.getBean((IMObject)workList);
        return bean.getValue("taskTypes", EntityRelationship.class, Predicates.targetEquals((Reference)taskType)) != null;
    }

    private Entity getDefaultTaskType(Entity workList) {
        return EntityRelationshipHelper.getDefaultTarget((Entity)workList, (String)"taskTypes", (boolean)true, (ArchetypeService)this.service);
    }
}

