/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.business.domain.im.common.SequencedPeriodRelationship;
import org.openvpms.component.business.service.archetype.functor.SequenceComparator;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.scheduling.AbstractSchedules;

public class TaskSchedules
extends AbstractSchedules {
    public TaskSchedules(Party location, Preferences prefs) {
        this(location, prefs, (LocationRules)ServiceHelper.getBean(LocationRules.class));
    }

    public TaskSchedules(Party location, Preferences prefs, LocationRules rules) {
        super(location, "entity.organisationWorkListView", prefs, rules);
    }

    @Override
    public List<Entity> getScheduleViews() {
        Party location = this.getLocation();
        return location != null ? new ArrayList(this.getLocationRules().getWorkListViews(location)) : Collections.emptyList();
    }

    @Override
    public Entity getDefaultScheduleView() {
        Reference reference = this.getScheduleView("entity.preferenceGroupWorkList");
        LocationRules rules = this.getLocationRules();
        Entity view = null;
        Party location = this.getLocation();
        if (reference != null && rules.hasWorkListView(location, reference)) {
            view = (Entity)IMObjectHelper.getObject((Reference)reference);
        }
        if (view == null) {
            view = rules.getDefaultWorkListView(location);
        }
        return view;
    }

    @Override
    public Entity getDefaultScheduleView(List<Entity> views) {
        Party location;
        Entity view = this.getScheduleView("entity.preferenceGroupWorkList", views);
        if (view == null && (location = this.getLocation()) != null) {
            view = this.getLocationRules().getDefaultWorkListView(location);
        }
        return view;
    }

    @Override
    public List<Entity> getSchedules(Entity view) {
        IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)view);
        Policy policy = Policies.active(SequencedPeriodRelationship.class, (Comparator)SequenceComparator.INSTANCE);
        return bean.getTargets("workLists", Entity.class, policy);
    }

    @Override
    public Entity getDefaultSchedule(Entity view, List<Entity> schedules) {
        return this.getSchedule("entity.preferenceGroupWorkList", schedules);
    }

    @Override
    public String getScheduleDisplayName() {
        return Messages.get((String)"workflow.scheduling.query.worklist");
    }
}

