/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.ArrayList;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.ListCellRenderer;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.TaskStatus;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.list.AbstractListCellRenderer;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleServiceQuery;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;
import org.openvpms.web.workspace.workflow.worklist.TaskSchedules;

public class TaskQuery
extends ScheduleServiceQuery {
    private final ActionListener statusRangeListener = new ActionListener(){

        public void onAction(ActionEvent event) {
            TaskQuery.this.onQuery();
        }
    };
    private SelectField statusRange;

    public TaskQuery(Context context, Preferences prefs) {
        super(ServiceHelper.getTaskService(), new TaskSchedules(context.getLocation(), prefs), prefs);
    }

    public void includeStatus(String status) {
        StatusRange range = this.getStatusRange();
        if (status != null && range != null && range != StatusRange.ALL) {
            boolean complete = TaskStatus.isComplete((String)status);
            if (range == StatusRange.INCOMPLETE && complete || range == StatusRange.COMPLETE && !complete) {
                this.statusRange.setSelectedItem((Object)StatusRange.ALL);
            }
        }
    }

    @Override
    protected void doLayout(Component container) {
        StatusRange defaultStatus;
        super.doLayout(container);
        this.statusRange = SelectFieldFactory.create((Object[])StatusRange.values());
        this.statusRange.setCellRenderer((ListCellRenderer)new StatusRangeListCellRenderer());
        String preference = this.getPreferences().getString("entity.preferenceGroupWorkList", "status", StatusRange.INCOMPLETE.toString());
        try {
            defaultStatus = StatusRange.valueOf(preference);
        }
        catch (IllegalArgumentException exception) {
            defaultStatus = StatusRange.INCOMPLETE;
        }
        this.statusRange.setSelectedItem((Object)defaultStatus);
        this.statusRange.addActionListener((nextapp.echo2.app.event.ActionListener)this.statusRangeListener);
        container.add((Component)LabelFactory.create((String)"actquery.status"));
        container.add((Component)this.statusRange);
        this.getFocusGroup().add((Component)this.statusRange);
    }

    @Override
    protected Reference getDefaultClinician() {
        return this.getPreferences().getReference("entity.preferenceGroupWorkList", "clinician", null);
    }

    @Override
    protected ScheduleTableModel.Highlight getDefaultHighlight() {
        ScheduleTableModel.Highlight result = null;
        String highlight = this.getPreferences().getString("entity.preferenceGroupWorkList", "highlight", null);
        if (highlight != null) {
            try {
                result = ScheduleTableModel.Highlight.valueOf(highlight);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    protected void onDateChanged() {
        Date date = this.getDate();
        Date today = DateRules.getToday();
        this.statusRange.removeActionListener((nextapp.echo2.app.event.ActionListener)this.statusRangeListener);
        if (date.equals(today)) {
            this.statusRange.setSelectedItem((Object)StatusRange.INCOMPLETE);
        } else {
            this.statusRange.setSelectedItem((Object)StatusRange.ALL);
        }
        this.statusRange.addActionListener((nextapp.echo2.app.event.ActionListener)this.statusRangeListener);
        this.onQuery();
    }

    @Override
    protected ScheduleEvents getEvents(Entity schedule, Date date) {
        ScheduleEvents result;
        ScheduleEvents events = super.getEvents(schedule, date);
        StatusRange range = this.getStatusRange();
        if (!events.getEvents().isEmpty() && range != StatusRange.ALL) {
            boolean complete = range == StatusRange.COMPLETE;
            ArrayList<PropertySet> filtered = new ArrayList<PropertySet>();
            for (PropertySet event : events.getEvents()) {
                String status = event.getString("act.status");
                if (complete) {
                    if (!TaskStatus.isComplete((String)status)) continue;
                    filtered.add(event);
                    continue;
                }
                if (!TaskStatus.isIncomplete((String)status)) continue;
                filtered.add(event);
            }
            result = new ScheduleEvents(filtered, events.getModHash());
        } else {
            result = events;
        }
        return result;
    }

    private StatusRange getStatusRange() {
        return (StatusRange)((Object)this.statusRange.getSelectedItem());
    }

    private static enum StatusRange {
        ALL,
        INCOMPLETE,
        COMPLETE;

    }

    private static class StatusRangeListCellRenderer
    extends AbstractListCellRenderer<StatusRange> {
        public StatusRangeListCellRenderer() {
            super(StatusRange.class);
        }

        protected String toString(Component list, StatusRange object, int index) {
            return Messages.get((String)("workflow.scheduling.statusrange." + object.name()));
        }

        protected boolean isAll(Component list, StatusRange object, int index) {
            return StatusRange.ALL == object;
        }

        protected boolean isNone(Component list, StatusRange object, int index) {
            return false;
        }
    }
}

