/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.worklist;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.rules.workflow.TaskRules;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.worklist.RestrictedWorkListParticipationEditor;
import org.openvpms.web.workspace.workflow.worklist.RestrictedWorkListQuery;
import org.openvpms.web.workspace.workflow.worklist.RestrictedWorkListTaskEditor;
import org.openvpms.web.workspace.workflow.worklist.TaskActEditor;

public class FollowUpTaskEditor
extends RestrictedWorkListTaskEditor {
    private List<Entity> workLists;
    private Entity defaultWorkList;

    public FollowUpTaskEditor(Act act, List<Entity> workLists, LayoutContext context) {
        super(act, null, context);
        this.initWorkLists(workLists);
        this.setStartTime(new Date());
        this.initWorkListEditor();
    }

    public String getDisplayName() {
        return Messages.get((String)"patient.followup.task");
    }

    public IMObjectEditor newInstance() {
        return new FollowUpTaskEditor((Act)this.reload((IMObject)this.getObject()), this.workLists, this.getLayoutContext());
    }

    public static List<Entity> getWorkLists(Context context) {
        return FollowUpTaskEditor.getWorkLists(context.getClinician(), context.getUser(), context.getLocation());
    }

    public static List<Entity> getWorkLists(User clinician, User user, Party location) {
        LinkedHashSet matches = new LinkedHashSet();
        UserRules userRules = (UserRules)ServiceHelper.getBean(UserRules.class);
        LocationRules locationRules = (LocationRules)ServiceHelper.getBean(LocationRules.class);
        if (clinician != null) {
            matches.addAll(userRules.getFollowupWorkLists(clinician));
        }
        if (user != null && !Objects.equals(user, clinician)) {
            matches.addAll(userRules.getFollowupWorkLists(user));
        }
        if (location != null) {
            matches.addAll(locationRules.getFollowupWorkLists(location));
        }
        return new ArrayList<Entity>(matches);
    }

    public static List<Entity> getWorkLists(Context context, Entity taskType) {
        List<Entity> worklists = FollowUpTaskEditor.getWorkLists(context);
        TaskRules rules = (TaskRules)ServiceHelper.getBean(TaskRules.class);
        return worklists.stream().filter(worklist -> rules.hasTaskType(worklist, taskType)).collect(Collectors.toList());
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        this.getParticipationEditor("clinician", false).addModifiableListener(modifiable -> this.onClinicianChanged());
    }

    @Override
    protected Entity getDefaultWorkList() {
        return this.defaultWorkList;
    }

    @Override
    protected ParticipationEditor<Entity> createWorkListEditor(Participation participation) {
        return new RestrictedWorkListParticipationEditor(participation, this.getObject(), this.getLayoutContext()){

            @Override
            protected Query<Entity> createWorkListQuery(String name) {
                Entity entity;
                RestrictedWorkListQuery query = new RestrictedWorkListQuery(FollowUpTaskEditor.this.workLists);
                if (!(name == null || (entity = this.getEntity()) != null && StringUtils.equals((CharSequence)entity.getName(), (CharSequence)name))) {
                    query.setValue(name);
                }
                return query;
            }
        };
    }

    protected PropertySet createPropertySet(IMObject object, ArchetypeDescriptor archetype, Variables variables) {
        return new PropertySetBuilder(object, archetype, variables).setReadOnly("customer").setReadOnly("patient").build();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new FollowUpLayoutStrategy();
    }

    private void initWorkLists(List<Entity> workLists) {
        this.defaultWorkList = !workLists.isEmpty() ? workLists.get(0) : null;
        this.workLists = new ArrayList<Entity>(workLists);
        IMObjectSorter.sort(workLists, (String[])new String[]{"name"});
    }

    private void onClinicianChanged() {
        Context context = this.getLayoutContext().getContext();
        this.initWorkLists(FollowUpTaskEditor.getWorkLists(this.getClinician(), context.getUser(), context.getLocation()));
    }

    private class FollowUpLayoutStrategy
    extends TaskActEditor.LayoutStrategy {
        public FollowUpLayoutStrategy() {
            super(FollowUpTaskEditor.this);
            this.setArchetypeNodes(new ArchetypeNodes(true, true).simple(new String[]{"worklist"}).order("worklist", "startTime").order("taskType", "startTime").hidden(true));
            this.addComponent(new ComponentState((PropertyEditor)FollowUpTaskEditor.this.getWorkListCollectionEditor()));
        }
    }
}

