/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling.view;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public abstract class ParticipantScheduleEventTableModel
extends DescriptorTableModel<Act> {
    private int dateIndex;
    private int timeIndex;
    protected static final String PATIENT = "patient";
    protected static final String STATUS = "status";
    protected static final String NOTES = "notes";

    public ParticipantScheduleEventTableModel(LayoutContext context) {
        super(context);
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        TableColumn col = this.getColumn(column);
        int index = col.getModelIndex();
        if (index == this.dateIndex) {
            return new SortConstraint[]{Constraints.sort((String)"startTime", (boolean)ascending)};
        }
        return super.getSortConstraints(column, ascending);
    }

    protected Object getValue(Act object, TableColumn column, int row) {
        Object result = null;
        int index = column.getModelIndex();
        if (index == this.dateIndex || index == this.timeIndex) {
            Date startTime = object.getActivityStartTime();
            if (startTime != null) {
                result = index == this.dateIndex ? DateFormatter.formatDate((Date)startTime, (boolean)false) : DateFormatter.formatTime((Date)startTime, (boolean)false);
            }
        } else {
            result = super.getValue((IMObject)object, column, row);
        }
        return result;
    }

    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        DefaultTableColumnModel model = (DefaultTableColumnModel)super.createColumnModel(archetypes, context);
        this.dateIndex = this.getNextModelIndex((TableColumnModel)model);
        this.timeIndex = this.dateIndex + 1;
        TableColumn date = ParticipantScheduleEventTableModel.createTableColumn((int)this.dateIndex, (String)"table.act.date");
        TableColumn time = ParticipantScheduleEventTableModel.createTableColumn((int)this.timeIndex, (String)"table.act.time");
        model.addColumn(date);
        model.moveColumn(model.getColumnCount() - 1, 0);
        model.addColumn(time);
        model.moveColumn(model.getColumnCount() - 1, 1);
        return model;
    }
}

