/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import nextapp.echo2.app.Button;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workflow.Workflow;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.CRUDWindowListener;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.workflow.WorkflowFactory;
import org.openvpms.web.workspace.workflow.checkin.NewFlowSheetTask;
import org.openvpms.web.workspace.workflow.otc.OverTheCounterWorkflow;

public abstract class ScheduleCRUDWindow
extends AbstractCRUDWindow<Act> {
    protected static final String CONSULT_ID = "button.consult";
    protected static final String CHECKOUT_ID = "button.checkout";
    protected static final String OVER_THE_COUNTER_ID = "button.OTC";
    private static final String NEW_FLOW_SHEET_ID = "button.newflowsheet";
    private final FlowSheetServiceFactory flowSheetServiceFactory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);

    public ScheduleCRUDWindow(Archetypes<Act> archetypes, ScheduleActions actions, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)actions, context, help);
    }

    public MailContext getMailContext() {
        Object context = null;
        if (this.getObject() != null) {
            context = CustomerMailContext.create((Act)this.getObject(), this.getContext(), this.getHelpContext());
        }
        if (context == null) {
            context = super.getMailContext();
        }
        return context;
    }

    protected ScheduleActions getActions() {
        return (ScheduleActions)super.getActions();
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        boolean newFlowSheetEnabled = enable && this.getActions().canCreateFlowSheet((Act)this.getObject(), this.getContext().getLocation(), this.flowSheetServiceFactory);
        buttons.setEnabled(NEW_FLOW_SHEET_ID, newFlowSheetEnabled);
        this.enablePrintPreview(buttons, enable);
    }

    protected void onRefresh(Act object) {
        Act refreshed = (Act)IMObjectHelper.reload((IMObject)object);
        this.setObject((IMObject)refreshed);
        CRUDWindowListener listener = this.getListener();
        if (listener != null) {
            listener.refresh((IMObject)object);
        }
    }

    protected void deleteDisallowed(Act act) {
        String name = this.getArchetypes().getDisplayName();
        String status = act.getStatus();
        String title = Messages.format((String)"act.nodelete.title", (Object[])new Object[]{name});
        String message = Messages.format((String)"act.nodelete.message", (Object[])new Object[]{name, status});
        ErrorDialog.show((String)title, (String)message);
    }

    protected Button createConsultButton() {
        return ButtonFactory.create((String)CONSULT_ID, this::onConsult);
    }

    protected Button createCheckOutButton() {
        return ButtonFactory.create((String)CHECKOUT_ID, this::onCheckOut);
    }

    protected Button createOverTheCounterButton() {
        return ButtonFactory.create((String)OVER_THE_COUNTER_ID, this::onOverTheCounter);
    }

    protected Button createFlowSheetButton() {
        return ButtonFactory.create((String)NEW_FLOW_SHEET_ID, this::onNewFlowSheet);
    }

    private void onConsult() {
        Act act = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (act != null && this.getActions().canCheckoutOrConsult(act)) {
            WorkflowFactory factory = (WorkflowFactory)ServiceHelper.getBean(WorkflowFactory.class);
            Workflow workflow = factory.createConsultWorkflow(act, this.getContext(), this.getHelpContext());
            workflow.addTaskListener((TaskListener)new DefaultTaskListener(){

                public void taskEvent(TaskEvent event) {
                    ScheduleCRUDWindow.this.onRefresh((Act)ScheduleCRUDWindow.this.getObject());
                }
            });
            workflow.start();
        } else {
            this.onRefresh((Act)this.getObject());
        }
    }

    private void onCheckOut() {
        Act act = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (act != null && this.getActions().canCheckoutOrConsult(act)) {
            WorkflowFactory factory = (WorkflowFactory)ServiceHelper.getBean(WorkflowFactory.class);
            Workflow workflow = factory.createCheckOutWorkflow(act, this.getContext(), this.getHelpContext());
            workflow.addTaskListener((TaskListener)new DefaultTaskListener(){

                public void taskEvent(TaskEvent event) {
                    ScheduleCRUDWindow.this.onRefresh((Act)ScheduleCRUDWindow.this.getObject());
                }
            });
            workflow.start();
        } else {
            this.onRefresh((Act)this.getObject());
        }
    }

    private void onOverTheCounter() {
        OverTheCounterWorkflow workflow = new OverTheCounterWorkflow(this.getContext(), this.getHelpContext());
        workflow.start();
    }

    private void onNewFlowSheet() {
        final Act object = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        Party location = this.getContext().getLocation();
        if (object != null && this.flowSheetServiceFactory.isSmartFlowSheetEnabled(location)) {
            NewFlowSheetTask task = new NewFlowSheetTask(object, location, this.flowSheetServiceFactory, this.getHelpContext());
            task.addTaskListener((TaskListener)new DefaultTaskListener(){

                public void taskEvent(TaskEvent event) {
                    ScheduleCRUDWindow.this.onRefresh(object);
                }
            });
            DefaultTaskContext context = new DefaultTaskContext(this.getContext(), this.getHelpContext());
            task.start((TaskContext)context);
        }
    }

    protected static abstract class ScheduleActions
    extends ActActions<Act> {
        protected ScheduleActions() {
        }

        public boolean canDelete(Act act) {
            return super.canDelete(act) && !"COMPLETED".equals(act.getStatus());
        }

        public abstract boolean canCheckoutOrConsult(Act var1);

        public boolean canCreateFlowSheet(Act act, Party location, FlowSheetServiceFactory factory) {
            if (location != null && TypeHelper.isA((IMObject)act, (String[])new String[]{"act.customerAppointment", "act.customerTask"}) && factory.isSmartFlowSheetEnabled(location)) {
                IMObjectBean bean = this.getBean((IMObject)act);
                return bean.getTargetRef("patient") != null;
            }
            return false;
        }
    }
}

