/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.scheduling;

import java.util.List;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.workspace.workflow.scheduling.Schedules;

public abstract class AbstractSchedules
implements Schedules {
    private final Party location;
    private final String viewShortName;
    private final Preferences prefs;
    private final LocationRules rules;

    public AbstractSchedules(Party location, String viewShortName, Preferences prefs, LocationRules rules) {
        this.location = location;
        this.viewShortName = viewShortName;
        this.prefs = prefs;
        this.rules = rules;
    }

    public Party getLocation() {
        return this.location;
    }

    @Override
    public String getScheduleViewShortName() {
        return this.viewShortName;
    }

    protected LocationRules getLocationRules() {
        return this.rules;
    }

    protected Entity getScheduleView(String preferenceGroup, List<Entity> views) {
        Reference reference = this.getScheduleView(preferenceGroup);
        return (Entity)IMObjectHelper.getObject((Reference)reference, views);
    }

    protected Reference getScheduleView(String preferenceGroup) {
        return this.prefs.getReference(preferenceGroup, "view", null);
    }

    protected Entity getSchedule(String preferenceGroup, List<Entity> schedules) {
        Reference reference = this.prefs.getReference(preferenceGroup, "schedule", null);
        return (Entity)IMObjectHelper.getObject((Reference)reference, schedules);
    }
}

