/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import echopointng.TabbedPane;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.ColumnLayoutData;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextApplicationInstance;
import org.openvpms.web.component.app.ContextListener;
import org.openvpms.web.component.app.GlobalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserAdapter;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.component.workspace.BrowserCRUDWindowTab;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.TabComponent;
import org.openvpms.web.component.workspace.TabbedWorkspace;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.tabpane.ObjectTabPaneModel;
import org.openvpms.web.echo.util.PeriodicTask;
import org.openvpms.web.echo.util.TaskQueues;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.roster.AreaRosterBrowser;
import org.openvpms.web.workspace.workflow.roster.AreaRosterCRUDWindow;
import org.openvpms.web.workspace.workflow.roster.RosterBrowser;
import org.openvpms.web.workspace.workflow.roster.RosterBrowserListener;
import org.openvpms.web.workspace.workflow.roster.RosterCRUDWindow;
import org.openvpms.web.workspace.workflow.roster.UserRosterBrowser;
import org.openvpms.web.workspace.workflow.roster.UserRosterCRUDWindow;

public class RosteringWorkspace
extends TabbedWorkspace<IMObject> {
    private final IArchetypeService service = ServiceHelper.getArchetypeService();
    private final PeriodicTask refresher;
    private final ContextListener locationListener;
    private Party location;
    private boolean enableRostering;
    private static final int MIN_REFRESH_INTERVAL = 5;

    public RosteringWorkspace(Context context) {
        super("workflow.rostering", context);
        this.location = context.getLocation();
        this.enableRostering = this.isRosteringEnabled(this.location);
        this.locationListener = (key, value) -> this.locationChanged((Party)value);
        IMObjectBean bean = this.service.getBean((IMObject)context.getPractice());
        int refreshInterval = bean.getInt("schedulingRefresh");
        if (refreshInterval > 0) {
            if (refreshInterval < 5) {
                refreshInterval = 5;
            }
            TaskQueues tasks = ContextApplicationInstance.getInstance().getTaskQueues();
            this.refresher = tasks.newTask(refreshInterval, this::refreshBrowser);
        } else {
            this.refresher = null;
        }
    }

    public void show() {
        ((GlobalContext)this.getContext()).addListener("party.organisationLocation", this.locationListener);
        if (this.refresher != null) {
            this.refresher.start();
        }
    }

    public void hide() {
        if (this.refresher != null) {
            this.refresher.stop();
        }
        ((GlobalContext)this.getContext()).removeListener(this.locationListener);
    }

    protected void addTabs(ObjectTabPaneModel<TabComponent> model) {
        this.addAreaBrowser(model);
        this.addEmployeeBrowser(model);
    }

    protected Class<IMObject> getType() {
        return IMObject.class;
    }

    protected void query() {
        if (this.refresher != null) {
            this.refresher.restart();
        }
    }

    protected boolean refreshWorkspace() {
        return true;
    }

    protected void onQuery() {
        this.firePropertyChange("summary", null, null);
    }

    private void refreshBrowser() {
        TabComponent component = this.getSelected();
        if (component instanceof BrowserTab) {
            ((BrowserTab)component).refresh();
        }
    }

    private void addAreaBrowser(ObjectTabPaneModel<TabComponent> model) {
        HelpContext help = this.subtopic("area");
        if (this.enableRostering) {
            DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), help);
            AreaRosterBrowser browser = new AreaRosterBrowser((LayoutContext)context);
            AreaRosterCRUDWindow window = new AreaRosterCRUDWindow(browser, this.getContext(), help);
            this.addTab("workflow.rostering.areas", model, (TabComponent)new BrowserTab(browser, window));
        } else {
            this.addRosteringDisabled("workflow.rostering.areas", model, help);
        }
    }

    private void addEmployeeBrowser(ObjectTabPaneModel<TabComponent> model) {
        HelpContext help = this.subtopic("employee");
        if (this.enableRostering) {
            DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), help);
            UserRosterBrowser browser = new UserRosterBrowser((LayoutContext)context);
            UserRosterCRUDWindow window = new UserRosterCRUDWindow(browser, this.getContext(), help);
            this.addTab("workflow.rostering.users", model, (TabComponent)new BrowserTab(browser, window));
        } else {
            this.addRosteringDisabled("workflow.rostering.users", model, help);
        }
    }

    private void addRosteringDisabled(String name, ObjectTabPaneModel<TabComponent> model, final HelpContext help) {
        this.addTab(name, model, new TabComponent(){

            public void show() {
            }

            public Component getComponent() {
                String message = RosteringWorkspace.this.location != null ? Messages.format((String)"workflow.rostering.disabled", (Object[])new Object[]{RosteringWorkspace.this.location.getName()}) : Messages.get((String)"workflow.rostering.selectlocation");
                Label label = LabelFactory.text((String)message, (String)"bold");
                ColumnLayoutData layout = new ColumnLayoutData();
                layout.setAlignment(Alignment.ALIGN_CENTER);
                label.setLayoutData((LayoutData)layout);
                return ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{label});
            }

            public HelpContext getHelpContext() {
                return help;
            }
        });
    }

    private void locationChanged(Party newLocation) {
        this.location = newLocation;
        this.enableRostering = this.isRosteringEnabled(this.location);
        TabbedPane pane = this.getTabbedPane();
        int index = pane.getSelectedIndex();
        ObjectTabPaneModel model = this.getModel();
        while (model.size() > 0) {
            model.removeTabAt(0);
        }
        this.addTabs((ObjectTabPaneModel<TabComponent>)model);
        if (index < 0) {
            pane.setSelectedIndex(-1);
            pane.setSelectedIndex(index);
        }
    }

    private boolean isRosteringEnabled(Party location) {
        boolean result = false;
        if (location != null) {
            IMObjectBean bean = this.service.getBean((IMObject)location);
            result = bean.getBoolean("rostering");
        }
        return result;
    }

    private static class RosterBrowserAdapter
    extends BrowserAdapter<PropertySet, Act> {
        RosterBrowserAdapter(RosterBrowser browser) {
            super((Browser)browser);
        }

        protected BrowserListener<PropertySet> adapt(final BrowserListener<Act> listener) {
            if (listener instanceof RosterBrowserListener) {
                return new RosterBrowserListener<PropertySet>(){

                    public void query() {
                        listener.query();
                    }

                    public void selected(PropertySet object) {
                        listener.selected((Object)this.convert(object));
                    }

                    public void browsed(PropertySet object) {
                        listener.browsed((Object)this.convert(object));
                    }

                    @Override
                    public void create() {
                        ((RosterBrowserListener)listener).create();
                    }

                    @Override
                    public void edit(PropertySet event) {
                        Act act = this.convert(event);
                        if (act != null) {
                            ((RosterBrowserListener)listener).edit(act);
                        }
                    }
                };
            }
            return super.adapt(listener);
        }

        protected Act convert(PropertySet object) {
            return object != null ? ((RosterBrowser)this.getBrowser()).getAct(object) : null;
        }
    }

    private static class BrowserTab
    extends BrowserCRUDWindowTab<Act> {
        BrowserTab(RosterBrowser browser, RosterCRUDWindow window) {
            super((Browser)new RosterBrowserAdapter(browser), (AbstractCRUDWindow)window, true, false);
        }

        public void refresh() {
            RosterBrowserAdapter adapter = (RosterBrowserAdapter)this.getBrowser();
            ((RosterBrowser)adapter.getBrowser()).refresh();
        }

        public Component getComponent() {
            return SplitPaneFactory.create((int)6, (String)"SchedulingWorkspace.Layout", (Component[])new Component[]{this.getWindow().getComponent(), this.getBrowser().getComponent()});
        }

        protected BrowserListener<Act> createListener() {
            return new RosterBrowserListener<Act>(){

                public void query() {
                    this.onQuery();
                }

                public void selected(Act object) {
                    this.onSelected((IMObject)object);
                }

                public void browsed(Act object) {
                    this.onBrowsed((IMObject)object);
                }

                @Override
                public void create() {
                    this.getWindow().create();
                }

                @Override
                public void edit(Act event) {
                    CRUDWindow window = this.getWindow();
                    window.setObject((IMObject)event);
                    window.edit();
                }
            };
        }
    }
}

