/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import echopointng.PopUp;
import echopointng.layout.TableLayoutDataEx;
import echopointng.table.TableCellRendererEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Table;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.colour.ColourHelper;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.roster.RosterTableModel;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;

class RosterTableCellRenderer
implements TableCellRendererEx {
    private final String key;
    private final RosterTableModel model;
    private final Context context;
    private final IArchetypeService service;
    private final ScheduleColours colours;

    public RosterTableCellRenderer(String key, RosterTableModel model, Context context) {
        this.key = key;
        this.model = model;
        this.context = context;
        this.colours = model.getColours();
        this.service = ServiceHelper.getArchetypeService();
    }

    public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
        Component component = value instanceof PropertySet ? this.getEvent((PropertySet)value, column) : this.getComponent(value, column, row);
        if (this.isCut(column, row)) {
            this.cutCell(table, component);
        }
        if (this.isSelected(column, row)) {
            this.highlightCell(component);
        }
        return component;
    }

    public boolean isSelectionCausingCell(Table table, int column, int row) {
        return column != 0;
    }

    public boolean isActionCausingCell(Table table, int column, int row) {
        return column != 0;
    }

    public XhtmlFragment getTableCellRendererContent(Table table, Object value, int column, int row) {
        return null;
    }

    protected Component getEvent(PropertySet event, int column) {
        Color background;
        Column result;
        Label next = null;
        Label previous = null;
        Date from = event.getDate("act.startTime");
        Date to = event.getDate("act.endTime");
        Date date = this.model.getDate(column);
        if (from.compareTo(date) < 0) {
            previous = LabelFactory.create(null, (String)"navigation.previous");
            from = date;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(DateFormatter.formatTime((Date)from, (boolean)false));
        buffer.append(" - ");
        Date following = DateRules.getNextDate((Date)date);
        if (to.compareTo(following) > 0) {
            next = LabelFactory.create(null, (String)"navigation.next");
            buffer.append(DateFormatter.formatTime((Date)following, (boolean)false));
        } else {
            buffer.append(DateFormatter.formatTime((Date)to, (boolean)false));
        }
        Label times = LabelFactory.text((String)buffer.toString());
        Label entity = LabelFactory.text((String)event.getString(this.key));
        Column component = ColumnFactory.create((Component[])new Component[]{times, entity});
        if (!Objects.equals(this.context.getLocation().getObjectReference(), event.getReference("location.objectReference"))) {
            component.add((Component)LabelFactory.text((String)event.getString("location.name")));
        }
        if (previous != null || next != null) {
            Row container = RowFactory.create();
            if (previous != null) {
                container.add((Component)previous);
            }
            container.add((Component)component);
            if (next != null) {
                container.add((Component)next);
            }
            result = container;
        } else {
            result = component;
        }
        String syncError = this.getSynchronisationError(event);
        if (syncError != null) {
            if (!(result instanceof Row)) {
                result = RowFactory.create((Component[])new Component[]{result});
            }
            Label error = LabelFactory.create(null, (String)"RosterEvent.ERROR");
            error.setToolTipText(syncError);
            error.setLayoutData((LayoutData)RowFactory.layout((Alignment)new Alignment(5, 6), (Extent)Styles.FULL_WIDTH));
            result.add((Component)error);
        }
        if ((background = this.getColour(event)) != null) {
            TableLayoutDataEx layoutData = new TableLayoutDataEx();
            layoutData.setBackground(background);
            Color foreground = ColourHelper.getTextColour((Color)background);
            TableHelper.setForeground((Component)result, (Color)foreground);
            result.setLayoutData((LayoutData)layoutData);
        }
        return result;
    }

    protected Component getComponent(Object value, int column, int row) {
        Label component = value == null ? (this.isSelected(column, row) ? LabelFactory.create((String)"workflow.scheduling.table.new") : LabelFactory.create()) : LabelFactory.text((String)value.toString());
        return component;
    }

    protected Color getColour(PropertySet event) {
        return this.colours.getColour((Reference)event.getReference("user.objectReference"));
    }

    protected boolean isSelected(int column, int row) {
        Cell cell = this.model.getSelected();
        return cell != null && row == cell.getRow() && column == cell.getColumn();
    }

    protected boolean isCut(int column, int row) {
        return this.model.isCut() && this.model.isMarked(column, row);
    }

    protected void highlightCell(Component component) {
        TableHelper.mergeStyle((Component)component, (String)"ScheduleTable.Selected", (boolean)true);
        Color colour = component.getForeground();
        if (colour != null && component.getComponentCount() != 0) {
            this.setForeground(component, colour);
        }
    }

    protected void cutCell(Table table, Component component) {
        this.setStrikethroughFont(component, table);
    }

    protected Font getFont(Component component) {
        Font font = component.getFont();
        if (font == null && (font = (Font)component.getRenderProperty("font")) == null && component.getParent() != null) {
            font = this.getFont(component.getParent());
        }
        return font;
    }

    private String getSynchronisationError(PropertySet event) {
        Set identities;
        String result = null;
        if (event.exists("synchronisation") && (identities = (Set)event.get("synchronisation")) != null) {
            for (Identity identity : identities) {
                IMObjectBean bean = this.service.getBean((IMObject)identity);
                if (!"ERROR".equals(bean.getString("status"))) continue;
                result = bean.getString("error");
                if (result != null) break;
                result = Messages.get((String)"workflow.rostering.unspecifiedsyncerror");
                break;
            }
        }
        return result;
    }

    private void setStrikethroughFont(Component component, Table table) {
        Font font = this.getFont((Component)table);
        if (font != null) {
            int style = 17;
            font = new Font(font.getTypeface(), style, font.getSize());
            this.setFont(component, font);
        }
    }

    private void setFont(Component component, Font font) {
        for (Component child : component.getComponents()) {
            this.setFont(child, font);
        }
        component.setFont(font);
    }

    private void setForeground(Component component, Color colour) {
        if (component instanceof Row) {
            for (Component child : component.getComponents()) {
                this.setForeground(child, colour);
            }
        } else if (!(component instanceof PopUp)) {
            component.setForeground(colour);
        }
    }
}

