/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.roster;

import java.util.List;
import java.util.Objects;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditDialog;
import org.openvpms.web.workspace.workflow.roster.RosterEventEditor;

public class RosterEventEditDialog
extends AbstractCalendarEventEditDialog {
    private final RosterService service = (RosterService)ServiceHelper.getBean(RosterService.class);
    private User user;

    public RosterEventEditDialog(RosterEventEditor editor, Context context) {
        super(editor, context);
    }

    @Override
    public RosterEventEditor getEditor() {
        return (RosterEventEditor)super.getEditor();
    }

    @Override
    protected void getState() {
        super.getState();
        this.user = this.getEditor().getUser();
    }

    @Override
    protected boolean noTimeCheckRequired() {
        boolean result = super.noTimeCheckRequired();
        if (result) {
            User newUser = this.getEditor().getUser();
            result = Objects.equals(newUser, this.user);
        }
        return result;
    }

    @Override
    protected boolean checkEventTimes(List<Times> times, boolean close) {
        List overlaps;
        boolean result = true;
        RosterEventEditor editor = this.getEditor();
        User user = editor.getUser();
        if (user != null && (overlaps = this.service.getOverlappingEvents(times, user, 1)) != null) {
            result = false;
            this.displayOverlapError((Times)overlaps.get(0));
        }
        return result;
    }
}

