/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.payment;

import java.math.BigDecimal;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.workflow.ConditionalTask;
import org.openvpms.web.component.workflow.ConfirmationTask;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.EvalTask;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.Tasks;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.checkout.PaymentEditTask;
import org.openvpms.web.workspace.workflow.payment.OpenDrawerTask;

public class PaymentWorkflow
extends WorkflowImpl {
    private final TaskContext initial;
    private final Context parent;
    private final BigDecimal chargeAmount;
    private final boolean prompt;

    public PaymentWorkflow(BigDecimal chargeAmount, Context context, HelpContext help) {
        this((TaskContext)new DefaultTaskContext(null, help), chargeAmount, true, context, help);
    }

    public PaymentWorkflow(BigDecimal chargeAmount, boolean prompt, Context context, HelpContext help) {
        this((TaskContext)new DefaultTaskContext(null, help), chargeAmount, prompt, context, help);
    }

    public PaymentWorkflow(TaskContext context, Context parent) {
        this(context, BigDecimal.ZERO, true, parent, context.getHelpContext());
    }

    public PaymentWorkflow(TaskContext context, Context parent, HelpContext help) {
        this(context, BigDecimal.ZERO, true, parent, help);
    }

    public PaymentWorkflow(TaskContext initial, BigDecimal chargeAmount, boolean prompt, Context parent, HelpContext help) {
        super(help);
        this.initial = initial;
        this.chargeAmount = chargeAmount;
        this.prompt = prompt;
        this.parent = parent;
        if (this.initial.getCustomer() == null) {
            this.initial.setCustomer(parent.getCustomer());
        }
        if (this.initial.getPatient() == null) {
            this.initial.setPatient(parent.getPatient());
        }
        if (this.initial.getClinician() == null) {
            this.initial.setClinician(parent.getClinician());
        }
        if (this.initial.getUser() == null) {
            this.initial.setUser(parent.getUser());
        }
        if (this.initial.getTill() == null) {
            this.initial.setTill(parent.getTill());
            this.initial.setTerminal(parent.getTerminal());
        }
        if (this.initial.getPractice() == null) {
            this.initial.setPractice(parent.getPractice());
        }
        if (this.initial.getLocation() == null) {
            this.initial.setLocation(parent.getLocation());
        }
    }

    public void start() {
        this.start(this.initial);
    }

    public void start(TaskContext context) {
        String payTitle = Messages.get((String)"workflow.payment.payaccount.title");
        String payMsg = Messages.get((String)"workflow.payment.payaccount.message");
        Tasks tasks = new Tasks(this.getHelpContext());
        tasks.addTask((Task)this.createPaymentTask(this.chargeAmount));
        tasks.addTask((Task)new OpenDrawerTask());
        tasks.addTask((Task)new SynchronousTask(){

            public void execute(TaskContext context) {
                PaymentWorkflow.this.parent.setCustomer(context.getCustomer());
                PaymentWorkflow.this.parent.setPatient(context.getPatient());
                PaymentWorkflow.this.parent.setTill(context.getTill());
                PaymentWorkflow.this.parent.setTerminal(context.getTerminal());
                if (!UserHelper.useLoggedInClinician((Context)context)) {
                    PaymentWorkflow.this.parent.setClinician(context.getClinician());
                }
            }
        });
        if (this.prompt) {
            boolean displayNo = !this.isRequired();
            this.addTask((Task)new ConditionalTask((EvalTask)new ConfirmationTask(payTitle, payMsg, displayNo, this.getHelpContext()), (Task)tasks));
        } else {
            this.addTask((Task)tasks);
        }
        super.start(context);
    }

    protected EditIMObjectTask createPaymentTask(BigDecimal amount) {
        return new PaymentEditTask(amount);
    }
}

