/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.order;

import java.util.ArrayList;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.clinician.ClinicianSelectField;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.location.LocationSelectField;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.LocationActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractSelectorListener;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;

public class CustomerOrderQuery
extends DateRangeActQuery<FinancialAct> {
    private static final ActStatuses statuses = new ActStatuses("act.customerOrderPharmacy");
    private final LocationSelectField locationSelector;
    private final IMObjectSelector<Party> customerSelector;
    private final ClinicianSelectField clinicianSelector;

    public CustomerOrderQuery(String[] shortNames, LayoutContext context) {
        super(shortNames, statuses, FinancialAct.class);
        this.locationSelector = this.createLocationSelector(context.getContext());
        this.customerSelector = this.createCustomerSelector(context);
        this.clinicianSelector = this.createClinicianSelector();
    }

    public Extent getHeight() {
        return super.getHeight(2);
    }

    protected ResultSet<FinancialAct> createResultSet(SortConstraint[] sort) {
        Party location = (Party)this.locationSelector.getSelectedItem();
        ArrayList list = new ArrayList();
        QueryHelper.addParticipantConstraint(list, (String)"customer", (String)"participation.customer", (Entity)((Entity)this.customerSelector.getObject()));
        QueryHelper.addParticipantConstraint(list, (String)"clinician", (String)"participation.clinician", (Entity)((Entity)this.clinicianSelector.getSelectedItem()));
        ParticipantConstraint[] participants = list.toArray(new ParticipantConstraint[0]);
        return new LocationActResultSet(this.getArchetypeConstraint(), participants, location, this.locationSelector.getLocations(), this.getFrom(), this.getTo(), this.getStatuses(), this.excludeStatuses(), this.getMaxResults(), sort);
    }

    protected Component createContainer() {
        return GridFactory.create((int)6);
    }

    protected void doLayout(Component container) {
        super.doLayout(container);
        this.addLocation(container);
        this.addCustomer(container);
        this.addClinician(container);
    }

    private void addLocation(Component container) {
        Label label = LabelFactory.create();
        label.setText(DescriptorHelper.getDisplayName((String)"act.customerOrderPharmacy", (String)"location", (ArchetypeService)this.getService()));
        container.add((Component)label);
        container.add((Component)this.locationSelector);
        this.getFocusGroup().add((Component)this.locationSelector);
    }

    private void addCustomer(Component container) {
        Label label = LabelFactory.create();
        label.setText(this.customerSelector.getType());
        container.add((Component)label);
        Component component = this.customerSelector.getComponent();
        container.add(component);
        this.customerSelector.getSelect().setFocusTraversalParticipant(false);
        this.getFocusGroup().add((Component)this.customerSelector.getTextField());
    }

    private void addClinician(Component container) {
        Label label = LabelFactory.create();
        label.setText(Messages.get((String)"label.clinician"));
        container.add((Component)label);
        container.add((Component)this.clinicianSelector);
        this.getFocusGroup().add((Component)this.clinicianSelector);
    }

    private LocationSelectField createLocationSelector(Context context) {
        LocationSelectField result = new LocationSelectField(context.getUser(), context.getPractice(), true);
        result.setSelectedItem((Object)context.getLocation());
        result.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                CustomerOrderQuery.this.onQuery();
            }
        });
        return result;
    }

    private IMObjectSelector<Party> createCustomerSelector(LayoutContext context) {
        IMObjectSelector selector = new IMObjectSelector(DescriptorHelper.getDisplayName((String)"party.customerperson", (ArchetypeService)this.getService()), context, new String[]{"party.customerperson"});
        AbstractSelectorListener<Party> listener = new AbstractSelectorListener<Party>(){

            public void selected(Party object) {
                CustomerOrderQuery.this.onQuery();
            }
        };
        selector.setListener((SelectorListener)listener);
        return selector;
    }

    private ClinicianSelectField createClinicianSelector() {
        ClinicianSelectField clinicianSelector = new ClinicianSelectField();
        clinicianSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                CustomerOrderQuery.this.onQuery();
            }
        });
        return clinicianSelector;
    }
}

