/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.order;

import org.apache.commons.lang3.ArrayUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.FinancialActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.print.BasicPrinterListener;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.component.workspace.ResultSetCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.order.OrderCharger;
import org.openvpms.web.workspace.customer.order.OrderChargerFactory;

public class CustomerOrderCRUDWindow
extends ResultSetCRUDWindow<FinancialAct> {
    private static final String INVOICE_ID = "button.invoice";

    public CustomerOrderCRUDWindow(Archetypes<FinancialAct> archetypes, Query<FinancialAct> query, ResultSet<FinancialAct> set, Context context, HelpContext help) {
        super(CustomerOrderCRUDWindow.filter(archetypes), (IMObjectActions)OrderActions.INSTANCE, query, set, context, help);
    }

    public Party getCustomer() {
        Party result = null;
        Act object = (Act)this.getObject();
        if (object != null) {
            IMObjectBean bean = this.getBean((IMObject)object);
            result = (Party)bean.getTarget("customer", Party.class);
        }
        return result;
    }

    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(INVOICE_ID, this.action(this::charge, act -> this.getActions().canInvoice((FinancialAct)act), true, "customer.order.invoice.title"));
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        OrderActions actions = this.getActions();
        FinancialAct order = (FinancialAct)this.getObject();
        buttons.setEnabled("view", enable);
        buttons.setEnabled("button.edit", enable && actions.canEdit((Act)order));
        buttons.setEnabled("button.delete", enable && actions.canDelete((Act)order));
        buttons.setEnabled(INVOICE_ID, enable && actions.canInvoice(order));
        buttons.setEnabled("button.print", enable);
        buttons.setEnabled("button.mail", enable);
    }

    protected OrderActions getActions() {
        return (OrderActions)super.getActions();
    }

    protected void charge(FinancialAct act) {
        IMObjectBean bean = this.getBean((IMObject)act);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        if (customer != null) {
            OrderChargerFactory factory = (OrderChargerFactory)ServiceHelper.getBean(OrderChargerFactory.class);
            Context context = this.getContext();
            OrderCharger charger = factory.create(customer, context, this.getHelpContext().subtopic("order"));
            charger.charge(act, () -> this.onRefresh((IMObject)act));
        } else {
            ((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().titleKey("customer.order.invalid", new Object[]{this.getDisplayName((IMObject)act)})).messageKey("property.error.required", new Object[]{this.getDisplayName((IMObject)act, "customer")})).show();
        }
    }

    protected IMPrinter<FinancialAct> createPrinter(final FinancialAct object) {
        InteractiveIMPrinter printer = (InteractiveIMPrinter)super.createPrinter((IMObject)object);
        printer.setListener((PrinterListener)new BasicPrinterListener(){

            public void printed(DocumentPrinter printer) {
                FinancialAct saved = (FinancialAct)CustomerOrderCRUDWindow.this.getActions().setPrinted((Act)object);
                if (saved != null) {
                    CustomerOrderCRUDWindow.this.onSaved((IMObject)saved, false);
                }
            }
        });
        return printer;
    }

    private static Archetypes<FinancialAct> filter(Archetypes<FinancialAct> archetypes) {
        Archetypes result;
        if (archetypes.contains("act.customerReturnInvestigation")) {
            String[] shortNames = (String[])ArrayUtils.removeElement((Object[])archetypes.getShortNames(), (Object)"act.customerReturnInvestigation");
            result = new Archetypes(shortNames, FinancialAct.class, archetypes.getDefaultShortName(), archetypes.getDisplayName());
        } else {
            result = archetypes;
        }
        return result;
    }

    private static class OrderActions
    extends FinancialActions<FinancialAct> {
        public static final OrderActions INSTANCE = new OrderActions();

        private OrderActions() {
        }

        public boolean canInvoice(FinancialAct order) {
            return "IN_PROGRESS".equals(order.getStatus());
        }
    }
}

