/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.edit.ViewActActions;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class ReplyCRUDWindow
extends AbstractViewCRUDWindow<Act> {
    static final String COMPLETED_ID = "button.messagecompleted";

    public ReplyCRUDWindow(Archetypes<Act> archetypes, Context context, HelpContext help) {
        super(archetypes, (IMObjectActions)new ReplyActions(), context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(COMPLETED_ID, this.action(this::onCompleted, object -> this.getActions().canComplete((Act)object), true, "workflow.sms.complete.title"));
        super.layoutButtons(buttons);
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        super.enableButtons(buttons, enable);
        buttons.setEnabled(COMPLETED_ID, enable && this.getActions().canComplete((Act)this.getObject()));
    }

    protected ReplyActions getActions() {
        return (ReplyActions)super.getActions();
    }

    private void onCompleted(Act act) {
        act.setStatus("COMPLETED");
        SaveHelper.save((IMObject)act);
        this.onRefresh((IMObject)act);
    }

    private static class ReplyActions
    extends ViewActActions<Act> {
        private ReplyActions() {
        }

        public boolean canEdit(Act reply) {
            IMObjectBean bean;
            boolean result = false;
            if (reply != null && reply.isA("act.smsReply") && (bean = ServiceHelper.getArchetypeService().getBean((IMObject)reply)).getValues("sms").isEmpty()) {
                result = true;
            }
            return result;
        }

        public boolean canComplete(Act reply) {
            return reply != null && reply.isA("act.smsReply") && !"COMPLETED".equals(reply.getStatus());
        }
    }
}

