/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.act.DefaultActCopyHandler;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditActions;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.messaging.messages.UserMessageEditor;

public class UserMessageEditDialog
extends EditDialog {
    public static final String SEND_ID = "send";
    private static final String[] SEND_CANCEL = new String[]{"send", "cancel"};

    public UserMessageEditDialog(UserMessageEditor editor, Context context) {
        super((IMObjectEditor)editor, EditActions.buttons((String[])SEND_CANCEL), context);
        this.setStyleName("UserMessageEditDialog");
    }

    public UserMessageEditor getEditor() {
        return (UserMessageEditor)super.getEditor();
    }

    protected void onButton(String button) {
        if (SEND_ID.equals(button)) {
            if (this.send()) {
                this.close(SEND_ID);
            }
        } else {
            super.onButton(button);
        }
    }

    private boolean send() {
        boolean result = false;
        DefaultValidator validator = new DefaultValidator();
        if (this.getEditor().validate((Validator)validator)) {
            result = this.doSend();
        } else {
            ValidationHelper.showError((Validator)validator);
        }
        return result;
    }

    private boolean doSend() {
        UserMessageEditor editor = this.getEditor();
        Act template = editor.getObject();
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new DefaultActCopyHandler(), (ArchetypeService)ServiceHelper.getArchetypeService());
        ArrayList toSave = new ArrayList();
        Date startTime = new Date();
        for (User user : editor.getToUsers()) {
            List objects = copier.apply((IMObject)template);
            Act act = (Act)objects.get(0);
            act.setActivityStartTime(startTime);
            act.setStatus("PENDING");
            IMObjectBean bean = IMObjectHelper.getBean((IMObject)act);
            bean.setTarget("to", (IMObject)user);
            toSave.addAll(objects);
        }
        return SaveHelper.save(toSave);
    }
}

