/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Row;
import org.openvpms.archetype.rules.message.MessageArchetypes;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupFilter;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.DateRangeActQuery;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.select.AbstractSelectorListener;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.im.select.SelectorListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;

public class MessageQuery
extends DateRangeActQuery<Act> {
    private final IMObjectSelector<Entity> user;
    private static final String[] ARCHETYPES = new String[]{"act.userMessage", MessageArchetypes.SYSTEM_MESSAGES, "act.auditMessage"};
    private static final ActStatuses STATUSES = new ActStatuses((LookupQuery)new LookupFilter((LookupQuery)new NodeLookupQuery("act.userMessage", "status"), false, new String[]{"READ"}), null);
    private static final String[] DEFAULT_STATUSES = new String[]{"PENDING", "READ"};

    public MessageQuery(Entity user, LayoutContext context) {
        super(user, "to", "participation.user", ARCHETYPES, STATUSES, Act.class);
        this.user = new IMObjectSelector(Messages.get((String)"messaging.user"), context, new String[]{"security.user"});
        this.user.setListener((SelectorListener)new AbstractSelectorListener<Entity>(){

            public void selected(Entity object) {
                MessageQuery.this.setEntity(object);
                MessageQuery.this.onQuery();
            }
        });
        this.user.setObject((Object)user);
        this.setStatus("PENDING");
        this.setDefaultSortConstraint(DESCENDING_START_TIME);
    }

    public ResultSet<Act> query(SortConstraint[] sort) {
        ActResultSet result = null;
        if (this.user.isValid()) {
            ParticipantConstraint[] participants = this.getEntityId() != null ? new ParticipantConstraint[]{this.getParticipantConstraint()} : new ParticipantConstraint[]{};
            result = new ActResultSet(this.getArchetypeConstraint(), participants, this.getFrom(), this.getTo(), this.getStatuses(), false, this.getConstraints(), this.getMaxResults(), sort);
        }
        return result;
    }

    public Entity getUser() {
        return (Entity)this.user.getObject();
    }

    public Extent getHeight() {
        return this.getHeight(2);
    }

    protected Component createContainer() {
        return ColumnFactory.create((String)"CellSpacing");
    }

    protected void doLayout(Component container) {
        Row row1 = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
        super.doLayout((Component)row1);
        Row row2 = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"messaging.user"), this.user.getComponent()});
        container.add((Component)row1);
        container.add((Component)row2);
        this.getFocusGroup().add(this.user.getFocusGroup());
    }

    protected String[] getStatuses() {
        String[] statuses = super.getStatuses();
        if (statuses.length == 1 && statuses[0].equals("PENDING")) {
            statuses = DEFAULT_STATUSES;
        }
        return statuses;
    }
}

