/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.merge;

import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.workflow.AbstractConfirmationTask;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.SelectIMObjectTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class MergeWorkflow<T extends IMObject>
extends WorkflowImpl {
    private final T object;
    private TaskContext initial;

    protected MergeWorkflow(T object, HelpContext help) {
        super(help);
        this.object = object;
    }

    public void start() {
        this.start(this.initial);
    }

    protected T getObject() {
        return this.object;
    }

    protected void init() {
        HelpContext help = this.getHelpContext();
        this.initial = this.createContext(help);
        final String displayName = DescriptorHelper.getDisplayName(this.object, (ArchetypeService)ServiceHelper.getArchetypeService());
        SelectIMObjectTask<T> select = this.createSelectTask((Context)this.initial);
        select.setTitle(Messages.format((String)"workflow.merge.select.title", (Object[])new Object[]{displayName, this.object.getName()}));
        select.setMessage(Messages.format((String)"workflow.merge.select.message", (Object[])new Object[]{displayName}));
        this.addTask((Task)select);
        this.addTask((Task)new AbstractConfirmationTask(help){

            protected ConfirmationDialog createConfirmationDialog(TaskContext context, HelpContext help) {
                String title = Messages.format((String)"workflow.merge.title", (Object[])new Object[]{displayName});
                return new ConfirmationDialog(title, MergeWorkflow.this.getConfirmationMessage(), help);
            }
        });
        this.addTask(this.createMergeTask());
    }

    protected TaskContext createContext(HelpContext help) {
        return new DefaultTaskContext(help);
    }

    protected abstract SelectIMObjectTask<T> createSelectTask(Context var1);

    protected abstract String getConfirmationMessage();

    protected abstract Task createMergeTask();
}

