/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.investigation;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.order.WebOrderConfirmation;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.frame.MonitoredFrame;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class OrderConfirmationDialog
extends ModalDialog {
    private final Act investigation;
    private boolean confirmed = false;

    public OrderConfirmationDialog(final Order order, final WebOrderConfirmation confirmation, Act investigation, final LaboratoryService service, HelpContext help) {
        super(Messages.get((String)"investigation.order.confirm.title"), new String[]{"skip"}, help);
        this.investigation = investigation;
        this.setContentWidth(confirmation.getWidth());
        this.setContentHeight(confirmation.getHeight());
        MonitoredFrame frame = new MonitoredFrame(confirmation.getUrl());
        frame.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                if (confirmation.isConfirmed(event.getActionCommand())) {
                    OrderConfirmationDialog.this.confirmed = true;
                    OrderConfirmationDialog.this.check(order, service);
                    OrderConfirmationDialog.this.close("ok");
                }
            }
        });
        this.getLayout().add((Component)frame);
    }

    public Act getInvestigation() {
        return this.investigation;
    }

    protected void onSkip() {
        if (!this.confirmed) {
            ConfirmationDialog.show((String)Messages.get((String)"investigation.order.skip.title"), (String)Messages.get((String)"investigation.order.skip.message"), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    OrderConfirmationDialog.this.confirmDeferred();
                    OrderConfirmationDialog.super.onSkip();
                }
            });
        } else {
            super.onSkip();
        }
    }

    private void confirmDeferred() {
        if ("CONFIRM".equals(this.investigation.getStatus2())) {
            this.investigation.setStatus2("CONFIRM_DEFERRED");
            ServiceHelper.getArchetypeService().save((IMObject)this.investigation);
        }
    }

    private void check(Order order, LaboratoryService service) {
        try {
            if (service.canCheck(order)) {
                service.check(order);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show((String)exception.getMessage(), (Throwable)exception);
        }
    }
}

