/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.util.Date;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.CageType;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

class Visit {
    private final IMObjectBean appointment;
    private final AppointmentRules appointmentRules;
    private final PatientRules patientRules;
    private final IArchetypeService service;
    private Act event;
    private Party patient;
    private CageType cageType;
    private Weight weight;
    private boolean changed;
    static final String BOARDING_CHARGED = "boardingCharged";
    static final String FIRST_PET_RATE = "firstPetRate";

    public Visit(Act event, Act appointment, AppointmentRules appointmentRules, PatientRules patientRules, IArchetypeService service) {
        this.event = event;
        this.appointment = appointment != null ? service.getBean((IMObject)appointment) : null;
        this.appointmentRules = appointmentRules;
        this.patientRules = patientRules;
        this.service = service;
    }

    public Act getEvent() {
        return this.event;
    }

    public Act reloadEvent() {
        Act act = (Act)this.service.get(this.event.getObjectReference(), Act.class);
        if (act != null) {
            this.event = act;
        }
        return act;
    }

    public Act getAppointment() {
        return this.appointment != null ? (Act)this.appointment.getObject(Act.class) : null;
    }

    public Party getPatient() {
        if (this.patient == null) {
            IMObjectBean bean = this.service.getBean((IMObject)this.event);
            this.patient = (Party)bean.getTarget("patient", Party.class);
            if (this.patient == null) {
                throw new IllegalStateException("The patient for visit=" + this.event.getId() + " cannot be null");
            }
        }
        return this.patient;
    }

    public CageType getCageType() {
        IMObjectBean scheduleBean;
        Entity type;
        Entity schedule;
        if (this.appointment != null && this.cageType == null && (schedule = (Entity)this.appointment.getTarget("schedule", Entity.class)) != null && (type = (Entity)(scheduleBean = this.service.getBean((IMObject)schedule)).getTarget("cageType", Entity.class, Policies.active())) != null) {
            this.cageType = new CageType(type, (ArchetypeService)this.service);
        }
        return this.cageType;
    }

    public boolean isLateCheckout() {
        return this.isLateCheckout(new Date());
    }

    public boolean isLateCheckout(Date endTime) {
        boolean result = false;
        CageType type = this.getCageType();
        if (type != null) {
            result = type.isLateCheckout(this.getEndTime(endTime));
        }
        return result;
    }

    public int getDays() {
        return this.getDays(new Date());
    }

    public int getDays(Date endTime) {
        return this.appointmentRules.getBoardingNights(this.event.getActivityStartTime(), this.getEndTime(endTime));
    }

    public boolean isOvernight(Date endTime) {
        return !DateRules.dateEquals((Date)this.event.getActivityStartTime(), (Date)this.getEndTime(endTime));
    }

    public boolean isFirstPet() {
        return this.appointment != null && this.appointment.getBoolean(FIRST_PET_RATE, false);
    }

    public void setFirstPet(boolean firstPet) {
        if (this.appointment != null && firstPet != this.isFirstPet()) {
            this.appointment.setValue(FIRST_PET_RATE, (Object)firstPet);
            this.changed = true;
        }
    }

    public Date getStartTime() {
        return this.event.getActivityStartTime();
    }

    public Date getEndTime() {
        return this.event.getActivityEndTime();
    }

    public Date getEndTime(Date endTime) {
        if (this.event.getActivityEndTime() != null) {
            endTime = this.event.getActivityEndTime();
        }
        return endTime;
    }

    public Reference getScheduleRef() {
        return this.appointment != null ? this.appointment.getTargetRef("schedule") : null;
    }

    public Weight getWeight() {
        if (this.weight == null) {
            this.weight = this.patientRules.getWeight(this.getPatient());
        }
        return this.weight;
    }

    public boolean isCharged() {
        return this.appointment != null && this.appointment.getBoolean(BOARDING_CHARGED, false);
    }

    public boolean needsCharge() {
        boolean result = false;
        if (!this.isCharged()) {
            result = this.getProduct(new Date()) != null;
        }
        return result;
    }

    public Product getProduct(Date endTime) {
        Product result = null;
        CageType cageType = this.getCageType();
        if (cageType != null) {
            Date visitEndTime = this.getEndTime(endTime);
            int days = this.getDays(visitEndTime);
            boolean overnight = days > 1 || this.isOvernight(visitEndTime);
            result = cageType.getProduct(days, overnight, this.isFirstPet());
        }
        return result;
    }

    public void setCharged(boolean charged) {
        if (this.appointment != null && charged != this.isCharged()) {
            this.appointment.setValue(BOARDING_CHARGED, (Object)charged);
            this.changed = true;
        }
    }

    public void save() {
        if (this.changed && this.appointment != null) {
            this.appointment.save();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Visit) {
            return this.event.equals(((Visit)obj).event);
        }
        return false;
    }

    public int hashCode() {
        return this.event.hashCode();
    }
}

