/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.component.business.service.archetype.functor.ActComparator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.domain.practice.Location;
import org.openvpms.insurance.internal.InsuranceFactory;
import org.openvpms.insurance.service.GapInsuranceService;
import org.openvpms.insurance.service.InsuranceService;
import org.openvpms.insurance.service.InsuranceServices;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.ConditionalTask;
import org.openvpms.web.component.workflow.ConfirmationTask;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.EvalTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.Tasks;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsuranceClaimTask
extends Tasks {
    private final Map<Act, Party> activePolicies = new LinkedHashMap<Act, Party>();
    private final boolean gapClaim;
    private final InsuranceRules rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
    private Act policy;
    private Party insurer;
    private static final Logger log = LoggerFactory.getLogger(InsuranceClaimTask.class);

    public InsuranceClaimTask(List<Act> policies, boolean gapClaim, HelpContext help) {
        super(help);
        policies.sort(ActComparator.descending());
        for (Act policy : policies) {
            Party insurer = this.rules.getInsurer(policy);
            if (insurer == null) continue;
            this.activePolicies.put(policy, insurer);
        }
        this.gapClaim = gapClaim;
        this.setRequired(false);
    }

    protected void initialise(TaskContext context) {
        if (!this.activePolicies.isEmpty()) {
            if (this.gapClaim) {
                this.addTask((Task)new GapClaimTask(context.getHelpContext()));
            } else {
                ConfirmationTask confirm = this.createClaimConfirmationTask(context, this.activePolicies);
                this.addTask((Task)new ConditionalTask((EvalTask)confirm, (Task)new EditClaimTask()));
            }
        }
    }

    private void setSelectedPolicy(Map.Entry<Act, Party> entry) {
        if (entry != null) {
            this.policy = entry.getKey();
            this.insurer = entry.getValue();
        } else {
            this.policy = null;
            this.insurer = null;
        }
    }

    private ConfirmationTask createClaimConfirmationTask(TaskContext context, Map<Act, Party> policies) {
        String title = this.gapClaim ? Messages.get((String)"patient.insurance.gapclaim.title") : Messages.get((String)"patient.insurance.claim.title");
        String message = null;
        if (policies.size() > 1) {
            message = this.gapClaim ? Messages.get((String)"patient.insurance.gapclaim.multiplepolicies") : Messages.get((String)"patient.insurance.claim.multiplepolicies");
        } else {
            Party insurer = policies.values().stream().findFirst().orElse(null);
            if (insurer != null) {
                message = this.gapClaim ? Messages.format((String)"patient.insurance.gapclaim.message", (Object[])new Object[]{insurer.getName()}) : Messages.format((String)"patient.insurance.claim.message", (Object[])new Object[]{insurer.getName()});
            }
        }
        return new ConfirmClaimTask(title, message, policies, context.getHelpContext());
    }

    private static class ErrorTask
    extends AbstractTask {
        private final String preamble;
        private final Throwable error;
        private final Runnable retryListener;

        public ErrorTask(String preamble, Throwable error, Runnable retryListener) {
            this.preamble = preamble;
            this.error = error;
            this.retryListener = retryListener;
            this.setRequired(false);
        }

        public void start(TaskContext context) {
            ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().preamble(this.preamble)).message(ErrorFormatter.format((Throwable)this.error))).buttons(new String[]{"retry", "skip", "cancel"})).listener((WindowPaneListener)new PopupDialogListener(){

                public void onRetry() {
                    retryListener.run();
                    this.notifyCompleted();
                }

                public void onSkip() {
                    this.notifySkipped();
                }

                public void onCancel() {
                    this.notifyCancelled();
                }
            })).show();
        }
    }

    private class ConfirmClaimTask
    extends ConfirmationTask {
        private final Map<Act, Party> policies;

        public ConfirmClaimTask(String title, String message, Map<Act, Party> policies, HelpContext help) {
            super(title, message, help);
            this.policies = policies;
            this.setRequired(false);
        }

        protected ConfirmationDialog createConfirmationDialog(String title, String message, String[] buttons, HelpContext help) {
            return new ClaimConfirmationDialog(title, message, buttons, help);
        }

        private class ClaimConfirmationDialog
        extends ConfirmationDialog {
            public ClaimConfirmationDialog(String title, String message, String[] buttons, HelpContext help) {
                super(title, message, buttons, help);
            }

            protected void onYes() {
                if (InsuranceClaimTask.this.policy != null) {
                    super.onYes();
                }
            }

            protected void doLayout() {
                Label message = LabelFactory.text((String)this.getMessage());
                Column container = ColumnFactory.create((String)"WideCellSpacing", (Component[])new Component[]{message});
                if (ConfirmClaimTask.this.policies.size() > 1) {
                    ButtonGroup group = new ButtonGroup();
                    Column column = ColumnFactory.create((String)"CellSpacing");
                    boolean first = true;
                    for (Map.Entry entry : ConfirmClaimTask.this.policies.entrySet()) {
                        RadioButton button = ButtonFactory.text((String)((Party)entry.getValue()).getName(), (ButtonGroup)group, () -> InsuranceClaimTask.this.setSelectedPolicy(entry));
                        if (first) {
                            button.setSelected(true);
                            InsuranceClaimTask.this.setSelectedPolicy(entry);
                            first = false;
                        }
                        column.add((Component)button);
                    }
                    container.add((Component)column);
                } else {
                    Map.Entry entry = ConfirmClaimTask.this.policies.entrySet().stream().findFirst().orElse(null);
                    InsuranceClaimTask.this.setSelectedPolicy(entry);
                }
                this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{container}));
            }
        }
    }

    private class GapClaimTask
    extends Tasks {
        public GapClaimTask(HelpContext context) {
            super(context);
            this.setRequired(false);
        }

        protected void initialise(TaskContext context) {
            this.addTask((Task)new AbstractTask(){

                public void start(TaskContext context) {
                    GapClaimTask.this.run(context);
                    this.notifyCompleted();
                }
            });
        }

        private void run(TaskContext context) {
            LinkedHashMap<Act, Party> gapPolicies = new LinkedHashMap<Act, Party>();
            boolean rerun = false;
            for (Map.Entry entry : InsuranceClaimTask.this.activePolicies.entrySet()) {
                Act policy = (Act)entry.getKey();
                Party insurer = (Party)entry.getValue();
                try {
                    if (!this.isGapClaimAvailable(policy, insurer, context)) continue;
                    gapPolicies.put(policy, insurer);
                }
                catch (Throwable exception) {
                    String preamble = Messages.format((String)"patient.insurance.gapclaim.notavailable", (Object[])new Object[]{insurer.getName()});
                    log.error(preamble + " " + exception.getMessage(), exception);
                    ErrorTask task = new ErrorTask(preamble, exception, () -> this.initialise(context));
                    this.addTask((Task)task);
                    rerun = true;
                    break;
                }
            }
            if (!rerun && !gapPolicies.isEmpty()) {
                ConfirmationTask confirm = InsuranceClaimTask.this.createClaimConfirmationTask(context, gapPolicies);
                this.addTask((Task)new ConditionalTask((EvalTask)confirm, (Task)new EditClaimTask()));
            }
        }

        private boolean isGapClaimAvailable(Act policy, Party insurer, TaskContext context) {
            boolean result = false;
            String policyNumber = InsuranceClaimTask.this.rules.getPolicyNumber(policy);
            InsuranceService insuranceService = ((InsuranceServices)ServiceHelper.getBean(InsuranceServices.class)).getService(insurer);
            if (insuranceService instanceof GapInsuranceService) {
                InsuranceFactory factory = (InsuranceFactory)ServiceHelper.getBean(InsuranceFactory.class);
                GapInsuranceService gapService = (GapInsuranceService)insuranceService;
                Location location = factory.getLocation(context.getLocation());
                result = gapService.getGapClaimAvailability(insurer, policyNumber, location).isAvailable();
            }
            return result;
        }
    }

    private class EditClaimTask
    extends EditIMObjectTask {
        public EditClaimTask() {
            super("act.patientInsuranceClaim");
        }

        public void start(TaskContext context) {
            FinancialAct claim = InsuranceClaimTask.this.rules.createClaim(InsuranceClaimTask.this.policy);
            if (InsuranceClaimTask.this.gapClaim) {
                IMObjectBean bean = ServiceHelper.getArchetypeService().getBean((IMObject)claim);
                bean.setValue("gapClaim", (Object)true);
            }
            context.setObject("act.patientInsuranceClaim", (IMObject)claim);
            super.start(context);
        }

        protected void onDialogClose(String action, IMObjectEditor editor, TaskContext context) {
            if ("button.submit".equals(action)) {
                super.onEditCompleted();
            } else {
                super.onDialogClose(action, editor, context);
            }
        }

        protected void onError(IMObject object, final TaskContext context, Throwable exception) {
            String preamble = Messages.format((String)"patient.insurance.claim.editerror", (Object[])new Object[]{InsuranceClaimTask.this.insurer.getName()});
            log.error(preamble + " " + exception.getMessage(), exception);
            ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().preamble(preamble)).message(ErrorFormatter.format((Throwable)exception))).buttons(new String[]{"retry", "skip", "cancel"})).listener((WindowPaneListener)new PopupDialogListener(){

                public void onRetry() {
                    EditClaimTask.this.start(context);
                }

                public void onSkip() {
                    EditClaimTask.this.notifySkipped();
                }

                public void onCancel() {
                    EditClaimTask.this.notifyCancelled();
                }
            })).show();
        }
    }
}

