/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentGenerator;
import org.openvpms.web.component.im.doc.DocumentGeneratorFactory;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.PrintActTask;
import org.openvpms.web.component.workflow.PrintIMObjectTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.PatientMedicalRecordLinker;

public class PrintPatientActTask
extends PrintActTask {
    public PrintPatientActTask(Act act, MailContext context, PrintIMObjectTask.PrintMode printMode) {
        super(act, context, printMode);
        this.setRequired(false);
    }

    public void start(final TaskContext context) {
        final DocumentAct object = (DocumentAct)this.getObject(context);
        if (TypeHelper.isA((IMObject)object, (String)"act.patientDocumentLetter")) {
            DocumentGenerator.AbstractListener listener = new DocumentGenerator.AbstractListener(){

                public void generated(Document document) {
                    PrintPatientActTask.this.print((IMObject)object, context);
                }

                public void cancelled() {
                    PrintPatientActTask.this.notifyCancelled();
                }

                public void skipped() {
                    PrintPatientActTask.this.notifySkipped();
                }

                public void error(Throwable cause) {
                    if (cause != null) {
                        ErrorHelper.show((Throwable)cause, () -> PrintPatientActTask.this.notifySkipped());
                    } else {
                        PrintPatientActTask.this.notifySkipped();
                    }
                }
            };
            DocumentGeneratorFactory factory = (DocumentGeneratorFactory)ServiceHelper.getBean(DocumentGeneratorFactory.class);
            DocumentGenerator generator = factory.create(object, (Context)context, context.getHelpContext(), (DocumentGenerator.Listener)listener);
            generator.generate(true, false, true);
        } else {
            super.start(context);
        }
    }

    protected void onPrinted(IMObject object, TaskContext context) {
        Act document = this.setPrinted((Act)object);
        Act event = this.getEvent(document, context);
        if (event != null) {
            PatientMedicalRecordLinker linker = new PatientMedicalRecordLinker(event, document);
            if (Retryer.run((Retryable)linker)) {
                context.setObject("act.patientClinicalEvent", (IMObject)event);
                this.notifyCompleted();
            } else {
                this.notifyCancelled();
            }
        } else {
            this.notifyCompleted();
        }
    }

    protected Act getEvent(Act document, TaskContext context) {
        return (Act)context.getObject("act.patientClinicalEvent");
    }
}

