/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.ReferenceDataService;
import org.openvpms.smartflow.model.Department;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.list.PairListModel;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusGroup;

public class FlowSheetPanel {
    private final IArchetypeService service;
    private final CheckBox create;
    private final SelectField departments;
    private final SelectField templates;
    private final SpinBox expectedStay;
    private final FocusGroup focusGroup = new FocusGroup("FlowSheetPanel");
    private Component component;

    public FlowSheetPanel(FlowSheetServiceFactory factory, Party location, int departmentId, String templateName, int stayDuration, boolean canDisable, IArchetypeService service) {
        this.service = service;
        ReferenceDataService referenceData = factory.getReferenceDataService(location);
        this.departments = this.getDepartments(referenceData.getDepartments());
        this.setDepartmentId(departmentId);
        List names = referenceData.getTreatmentTemplates();
        this.templates = SelectFieldFactory.create((List)names);
        this.templates.setStyleName("edit");
        this.setTemplate(templateName);
        this.expectedStay = new SpinBox(0, 99);
        this.expectedStay.setStyleName("edit");
        this.setExpectedStay(stayDuration);
        if (canDisable) {
            this.create = CheckBoxFactory.create((boolean)true);
            this.create.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                }
            });
            this.create.addPropertyChangeListener(evt -> this.onCreateChanged());
        } else {
            this.create = null;
        }
    }

    public boolean createFlowSheet() {
        return this.create != null && this.create.isSelected();
    }

    public void setCreateFlowSheet(boolean create) {
        if (this.create != null) {
            this.create.setSelected(create);
        }
    }

    public void setWorkList(Entity worklist) {
        IMObjectBean bean = this.service.getBean((IMObject)worklist);
        this.setCreateFlowSheet(bean.getBoolean("createFlowSheet"));
        this.setDepartmentId(bean.getInt("defaultFlowSheetDepartment", -1));
        this.setExpectedStay(bean.getInt("expectedHospitalStay"));
        this.setTemplate(bean.getString("defaultFlowSheetTemplate"));
    }

    public Component getComponent() {
        if (this.component == null) {
            ComponentGrid grid = new ComponentGrid();
            this.doLayout(grid, 2);
            this.component = grid.createGrid();
        }
        return this.component;
    }

    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    public void setDepartmentId(int departmentId) {
        if (departmentId > -1) {
            this.departments.setSelectedItem((Object)departmentId);
        }
    }

    public int getDepartmentId() {
        int result = -1;
        Object value = this.departments.getSelectedItem();
        if (value instanceof Integer) {
            result = (Integer)value;
        }
        return result;
    }

    public void setExpectedStay(int days) {
        if (days > 0) {
            this.expectedStay.setValue(days);
        } else {
            this.expectedStay.setValue(2);
        }
    }

    public int getExpectedStay() {
        return this.expectedStay.getValue();
    }

    public void setTemplate(String template) {
        DefaultListModel model = (DefaultListModel)this.templates.getModel();
        int index = model.indexOf((Object)template);
        if (index != -1) {
            this.templates.setSelectedIndex(index);
        }
    }

    public String getTemplate() {
        return (String)this.templates.getSelectedItem();
    }

    public void layout(ComponentGrid grid, int columns) {
        this.doLayout(grid, columns);
    }

    protected void doLayout(ComponentGrid grid, int columns) {
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.create != null) {
            components.add(LabelFactory.create((String)"workflow.flowsheet.create"));
            components.add(this.create);
            this.focusGroup.add((Component)this.create);
        }
        components.add(LabelFactory.create((String)"workflow.flowsheet.department"));
        components.add(this.departments);
        components.add(LabelFactory.create((String)"workflow.flowsheet.template"));
        components.add(this.templates);
        components.add(LabelFactory.create((String)"workflow.flowsheet.expectedStay"));
        components.add(this.expectedStay);
        grid.arrange(columns, components.toArray(new Component[0]));
        this.focusGroup.add((Component)this.departments);
        this.focusGroup.add((Component)this.templates);
        this.focusGroup.add(this.expectedStay.getFocusGroup());
    }

    private void onCreateChanged() {
        boolean selected = this.create.isSelected();
        this.departments.setEnabled(selected);
        this.templates.setEnabled(selected);
        this.expectedStay.setEnabled(selected);
    }

    private SelectField getDepartments(List<Department> departments) {
        PairListModel model = new PairListModel();
        for (Department department : departments) {
            model.add((Object)department.getDepartmentId(), (Object)department);
        }
        SelectField field = SelectFieldFactory.create((ListModel)model);
        field.setCellRenderer(PairListModel.RENDERER);
        field.setStyleName("edit");
        return field;
    }
}

