/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.Collection;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractBrowserListener;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workflow.PrintActTask;
import org.openvpms.web.component.workflow.PrintIMObjectTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.Tasks;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.workflow.WorkflowException;
import org.openvpms.web.workspace.workflow.checkin.PatientDocumentTemplateBrowser;
import org.openvpms.web.workspace.workflow.checkin.PrintPatientActTask;
import org.openvpms.web.workspace.workflow.checkin.ScheduleDocumentTemplateQuery;
import org.openvpms.web.workspace.workflow.i18n.WorkflowMessages;

public abstract class AbstractPrintPatientDocumentsTask
extends Tasks {
    private final PrintIMObjectTask.PrintMode printMode;
    private BrowserDialog<Entity> dialog;

    public AbstractPrintPatientDocumentsTask(PrintIMObjectTask.PrintMode printMode, HelpContext help) {
        super(help);
        this.printMode = printMode;
    }

    public void start(final TaskContext context) {
        Entity schedule = this.getSchedule(context);
        Entity worklist = this.getWorkList(context);
        if (ScheduleDocumentTemplateQuery.hasTemplates(schedule) || ScheduleDocumentTemplateQuery.hasTemplates(worklist)) {
            Party patient = context.getPatient();
            if (patient == null) {
                throw new WorkflowException(WorkflowMessages.contextHasNoPatient());
            }
            String title = Messages.get((String)"workflow.print.title");
            HelpContext help = context.getHelpContext().subtopic("print");
            final PatientDocumentTemplateBrowser browser = new PatientDocumentTemplateBrowser(new ScheduleDocumentTemplateQuery(schedule, worklist), (LayoutContext)new DefaultLayoutContext((Context)context, help));
            String[] buttons = this.canCancel() ? PopupDialog.OK_SKIP_CANCEL : PopupDialog.OK_SKIP;
            this.dialog = new BrowserDialog(title, buttons, (Browser)browser, help);
            this.enableOK(browser);
            browser.addBrowserListener((BrowserListener)new AbstractBrowserListener<Entity>(){

                public void selected(Entity object) {
                    AbstractPrintPatientDocumentsTask.this.enableOK(browser);
                }

                public void browsed(Entity object) {
                    AbstractPrintPatientDocumentsTask.this.enableOK(browser);
                }
            });
            this.dialog.setCloseOnSelection(false);
            this.dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    AbstractPrintPatientDocumentsTask.this.print(browser.getSelections(), context);
                }

                public void onSkip() {
                    AbstractPrintPatientDocumentsTask.this.notifySkipped();
                }

                public void onCancel() {
                    AbstractPrintPatientDocumentsTask.this.notifyCancelled();
                }

                public void onAction(String action) {
                    AbstractPrintPatientDocumentsTask.this.notifyCancelled();
                }

                protected void onAction(PopupDialog dialog) {
                    try {
                        super.onAction(dialog);
                    }
                    finally {
                        AbstractPrintPatientDocumentsTask.this.dialog = null;
                    }
                }
            });
            this.dialog.show();
        } else {
            this.notifyCompleted();
        }
    }

    public BrowserDialog<Entity> getBrowserDialog() {
        return this.dialog;
    }

    protected boolean canCancel() {
        return true;
    }

    protected abstract Entity getSchedule(TaskContext var1);

    protected abstract Entity getWorkList(TaskContext var1);

    protected PrintActTask createPrintTask(Act document, CustomerMailContext mailContext, PrintIMObjectTask.PrintMode printMode) {
        return new PrintPatientActTask(document, (MailContext)mailContext, printMode);
    }

    private void enableOK(PatientDocumentTemplateBrowser browser) {
        this.dialog.getButtons().setEnabled("ok", !browser.getSelections().isEmpty());
    }

    private void print(Collection<Entity> templates, TaskContext context) {
        CustomerMailContext mailContext = new CustomerMailContext((Context)context, context.getHelpContext());
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (Entity entity : templates) {
            DocumentTemplate template = new DocumentTemplate(entity, (ArchetypeService)service);
            String type = template.getType();
            if (type == null) continue;
            Act document = (Act)service.create(type, Act.class);
            IMObjectBean bean = service.getBean((IMObject)document);
            bean.setTarget("patient", (IMObject)context.getPatient());
            bean.setTarget("documentTemplate", (IMObject)entity);
            bean.setTarget("clinician", (IMObject)context.getClinician());
            this.addTask((Task)this.createPrintTask(document, mailContext, this.printMode));
        }
        super.start(context);
    }
}

