/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.sms;

import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.action.ObjectCallBuilder;
import org.openvpms.web.component.im.sms.SMSReplyUpdater;
import org.openvpms.web.component.im.sms.SMSViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AppointmentSMSViewer
extends SMSViewer {
    private final Act appointment;
    @Autowired
    private ActionFactory actionFactory;
    private static final Logger log = LoggerFactory.getLogger(AppointmentSMSViewer.class);
    private static final String SMS_STATUS = "smsStatus";

    public AppointmentSMSViewer(Act appointment, List<Act> sms, ArchetypeService service, SMSReplyUpdater replyUpdater, ActionFactory actionFactory) {
        super(sms, service, replyUpdater);
        this.appointment = appointment;
        this.actionFactory = actionFactory;
    }

    public void markAsRead() {
        super.markAsRead();
        ((ObjectCallBuilder)((ObjectCallBuilder)this.actionFactory.newAction().backgroundOnly().withObject((IMObject)this.appointment).useLatestInstanceOnRetry()).skipIfMissing()).asBean(bean -> {
            if (!"READ".equals(bean.getString(SMS_STATUS))) {
                bean.setValue(SMS_STATUS, (Object)"READ");
                bean.save();
            }
        }).onFailure(status -> log.warn("Failed to update appointment SMS status: {}", (Object)status.getReason())).run();
    }
}

