/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.sms;

import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.sms.service.SMSService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.sms.SMSDialog;
import org.openvpms.web.component.im.sms.SMSEditor;
import org.openvpms.web.component.im.sms.SMSHelper;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.reminder.AppointmentReminderEvaluator;
import org.openvpms.web.workspace.workflow.appointment.sms.AppointmentSMSEditor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class AppointmentSMSDialog
extends SMSDialog {
    private final Act appointment;

    public AppointmentSMSDialog(Act appointment, List<Contact> phones, Party customer, Party patient, Party location, Context context, HelpContext help) {
        super(phones, AppointmentSMSDialog.createContext(customer, patient, context), help);
        this.appointment = appointment;
        AppointmentSMSEditor editor = this.getEditor();
        editor.setSource(appointment);
        Entity template = SMSHelper.getAppointmentTemplate((Party)location);
        if (template != null) {
            try {
                AppointmentReminderEvaluator evaluator = (AppointmentReminderEvaluator)ServiceHelper.getBean(AppointmentReminderEvaluator.class);
                String message = evaluator.evaluate(template, appointment, location, context.getPractice());
                this.setMessage(message);
            }
            catch (Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
        this.resize("AppointmentSMSDialog.size");
    }

    public Act getAppointment() {
        Act result = (Act)IMObjectHelper.reload((IMObject)this.appointment);
        return result != null ? result : this.appointment;
    }

    protected boolean send() {
        boolean send = super.send();
        if (send) {
            PlatformTransactionManager transactionManager = ServiceHelper.getTransactionManager();
            TransactionTemplate template = new TransactionTemplate(transactionManager);
            template.executeWithoutResult(transactionStatus -> this.updateAppointment());
        }
        return send;
    }

    protected SMSEditor createEditor(List<Contact> phones, MacroVariables variables, Context context, SMSService smsService) {
        return new AppointmentSMSEditor(phones, (Variables)variables, context, smsService);
    }

    protected AppointmentSMSEditor getEditor() {
        return (AppointmentSMSEditor)super.getEditor();
    }

    private void updateAppointment() {
        Act reloaded = (Act)IMObjectHelper.reload((IMObject)this.appointment);
        if (reloaded != null) {
            AppointmentRules rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
            Date date = this.getEditor().disableReminder() ? new Date() : null;
            rules.setSMSReminderSent(reloaded, date);
        }
    }

    private static Context createContext(Party customer, Party patient, Context parent) {
        LocalContext context = new LocalContext(parent);
        context.setCustomer(customer);
        context.setPatient(patient);
        return context;
    }
}

