/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatHelper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ScheduleEventSeriesState {
    private final Act event;
    private final IArchetypeService service;
    private final Act first;
    private final Act series;
    private final RepeatExpression expression;
    private final List<ObjectSet> items;
    private final String displayName;

    public ScheduleEventSeriesState(Act event, IArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)event);
        this.event = event;
        this.service = service;
        Act act = this.series = bean.hasNode("repeat") ? (Act)bean.getSource("repeat", Act.class) : null;
        if (this.series != null) {
            IMObjectBean seriesBean = service.getBean((IMObject)this.series);
            List refs = seriesBean.getTargetRefs("items");
            ArchetypeQuery query = new ArchetypeQuery(event.getArchetype());
            query.getArchetypeConstraint().setAlias("act");
            query.add((IConstraint)new NodeSelectConstraint("id"));
            query.add((IConstraint)new NodeSelectConstraint("startTime"));
            query.add((IConstraint)new NodeSelectConstraint("status"));
            query.add((IConstraint)Constraints.sort((String)"startTime"));
            query.add((IConstraint)Constraints.in((String)"id", (Object[])QueryHelper.getIds((List)refs)));
            query.setMaxResults(-1);
            IPage objects = service.getObjects((IArchetypeQuery)query);
            this.items = objects.getResults();
            int index = this.getIndex();
            if (index == 0) {
                this.first = event;
            } else if (!this.items.isEmpty()) {
                Reference reference = this.getReference(0);
                this.first = (Act)service.get(reference, Act.class);
            } else {
                this.first = null;
            }
            this.expression = RepeatHelper.getExpression(seriesBean);
        } else {
            this.items = Collections.emptyList();
            this.first = null;
            this.expression = null;
        }
        this.displayName = DescriptorHelper.getDisplayName((IMObject)event, (ArchetypeService)service);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean hasSeries() {
        return this.series != null;
    }

    public Act getFirst() {
        return this.first;
    }

    public RepeatExpression getExpression() {
        return this.expression;
    }

    public RepeatCondition getCondition(int index) {
        RepeatCondition condition = null;
        if (this.series != null) {
            IMObjectBean bean = this.service.getBean((IMObject)this.series);
            condition = RepeatHelper.getCondition(bean, index);
        }
        return condition;
    }

    public boolean canEditSeries() {
        Date now = new Date();
        return this.first != null && this.canEditFrom(0, now);
    }

    public boolean canEditFuture() {
        Date now = new Date();
        int index = this.getIndex();
        return index >= 0 && this.canEditFrom(index, now);
    }

    public List<String> getNonPendingStatuses() {
        return this.getNonPendingStatuses(0);
    }

    public List<String> getFutureNonPendingStatuses() {
        return this.getNonPendingStatuses(this.getIndex());
    }

    public boolean delete() {
        TransactionCallbackWithoutResult callback = new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (ScheduleEventSeriesState.this.series != null) {
                    IMObjectBean bean = ScheduleEventSeriesState.this.service.getBean((IMObject)ScheduleEventSeriesState.this.series);
                    bean.removeTargets("items", (IMObject)ScheduleEventSeriesState.this.event, "repeat");
                    ScheduleEventSeriesState.this.service.save(Arrays.asList(ScheduleEventSeriesState.this.series, ScheduleEventSeriesState.this.event));
                    ScheduleEventSeriesState.this.service.remove((IMObject)ScheduleEventSeriesState.this.event);
                    if (bean.getValues("items").isEmpty()) {
                        ScheduleEventSeriesState.this.service.remove((IMObject)ScheduleEventSeriesState.this.series);
                    }
                }
            }
        };
        return this.execute(callback);
    }

    public boolean deleteFuture() {
        int index = this.getIndex();
        return index >= 0 && this.delete(index);
    }

    public boolean deleteSeries() {
        return this.series != null && this.delete(0);
    }

    public int getIndex() {
        for (int i = 0; i < this.items.size(); ++i) {
            ObjectSet set = this.items.get(i);
            if (this.getId(set) != this.event.getId()) continue;
            return i;
        }
        return -1;
    }

    private boolean delete(final int index) {
        TransactionCallbackWithoutResult callback = new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                IMObjectBean bean = ScheduleEventSeriesState.this.service.getBean((IMObject)ScheduleEventSeriesState.this.series);
                ArrayList<Act> acts = new ArrayList<Act>();
                for (int i = index; i < ScheduleEventSeriesState.this.items.size(); ++i) {
                    Reference reference = ScheduleEventSeriesState.this.getReference(i);
                    Act act = (Act)ServiceHelper.getArchetypeService().get(reference);
                    if (act == null) continue;
                    acts.add(act);
                    bean.removeTargets("items", (IMObject)act, "repeat");
                }
                ArrayList<Act> toSave = new ArrayList<Act>(acts);
                toSave.add(ScheduleEventSeriesState.this.series);
                ScheduleEventSeriesState.this.service.save(toSave);
                if (index == 0) {
                    acts.add(0, ScheduleEventSeriesState.this.series);
                }
                for (Act act : acts) {
                    ScheduleEventSeriesState.this.service.remove((IMObject)act);
                }
            }
        };
        return this.execute(callback);
    }

    private boolean execute(TransactionCallbackWithoutResult callback) {
        boolean result = false;
        TransactionTemplate template = new TransactionTemplate(ServiceHelper.getTransactionManager());
        try {
            template.execute((TransactionCallback)callback);
            result = true;
        }
        catch (Throwable exception) {
            ErrorHelper.show((Throwable)exception);
        }
        return result;
    }

    private boolean canEditFrom(int index, Date now) {
        boolean edit = true;
        for (int i = index + 1; i < this.items.size(); ++i) {
            if (this.canEdit(this.items.get(i), now)) continue;
            edit = false;
            break;
        }
        return edit;
    }

    private boolean canEdit(ObjectSet event, Date now) {
        Date startTime = event.getDate("act.startTime");
        return DateRules.compareTo((Date)startTime, (Date)now) > 0;
    }

    private List<String> getNonPendingStatuses(int index) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.event.isA("act.customerAppointment")) {
            for (int i = index + 1; i < this.items.size(); ++i) {
                String status = this.items.get(i).getString("act.status");
                if ("PENDING".equals(status) || result.contains(status)) continue;
                result.add(status);
            }
        }
        return result;
    }

    private Reference getReference(int index) {
        long id = this.getId(this.items.get(index));
        return new IMObjectReference(this.event.getArchetype(), id);
    }

    private long getId(ObjectSet set) {
        return set.getLong("act.id");
    }
}

