/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.GridLayoutData;
import org.openvpms.web.echo.button.ToggleButton;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpressionViewer;

class RepeatOnDaysOfMonthViewer
extends CronRepeatExpressionViewer {
    public RepeatOnDaysOfMonthViewer(CronRepeatExpression expression) {
        super(expression);
    }

    @Override
    public Component getComponent() {
        CronRepeatExpression expression = this.getExpression();
        CronRepeatExpression.DayOfMonth dayOfMonth = expression.getDayOfMonth();
        Grid grid = new Grid(7);
        grid.setInsets(new Insets(1));
        for (int i = 0; i < 31; ++i) {
            int day = i + 1;
            boolean selected = dayOfMonth.isSelected(day);
            ToggleButton button = new ToggleButton("" + day, selected);
            button.setAlignment(Alignment.ALIGN_RIGHT);
            button.setEnabled(false);
            grid.add((Component)button);
        }
        GridLayoutData layout = new GridLayoutData();
        layout.setColumnSpan(4);
        ToggleButton lastDay = new ToggleButton(Messages.get((String)"workflow.scheduling.appointment.lastday"), dayOfMonth.hasLast());
        lastDay.setLayoutData((LayoutData)layout);
        lastDay.setAlignment(Alignment.ALIGN_CENTER);
        grid.add((Component)lastDay);
        Label interval = LabelFactory.create();
        CronRepeatExpression.Month month = expression.getMonth();
        interval.setText(Messages.format((String)"workflow.scheduling.appointment.everymonth", (Object[])new Object[]{month.getInterval()}));
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{LabelFactory.create((String)"workflow.scheduling.appointment.onthe"), grid, interval});
    }
}

