/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Objects;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class CalendarBlockSeries
extends ScheduleEventSeries {
    public CalendarBlockSeries(Act event, IArchetypeService service) {
        super(event, service);
    }

    @Override
    protected boolean canCalculateSeries(ScheduleEventSeries.State state) {
        return super.canCalculateSeries(state) && ((BlockState)state).getBlockType() != null;
    }

    @Override
    protected ScheduleEventSeries.State createState(IMObjectBean bean) {
        return new BlockState(bean);
    }

    @Override
    protected ScheduleEventSeries.State copy(ScheduleEventSeries.State state) {
        return new BlockState((BlockState)state);
    }

    @Override
    protected void populate(IMObjectBean bean, ScheduleEventSeries.State state) {
        super.populate(bean, state);
        BlockState block = (BlockState)state;
        bean.setTarget("type", block.getBlockType());
        bean.setValue("name", (Object)block.getName());
        bean.setValue("notes", (Object)block.getNotes());
    }

    private static class BlockState
    extends ScheduleEventSeries.State {
        private Reference blockType;
        private String name;
        private String notes;

        public BlockState(IMObjectBean event) {
            super(event);
        }

        public BlockState(BlockState state) {
            super(state);
            this.blockType = state.blockType;
            this.name = state.getName();
            this.notes = state.getNotes();
        }

        @Override
        public void update(IMObjectBean event) {
            super.update(event);
            this.blockType = event.getTargetRef("type");
            this.name = event.getString("name");
            this.notes = event.getString("notes");
        }

        public Reference getBlockType() {
            return this.blockType;
        }

        public String getName() {
            return this.name;
        }

        public String getNotes() {
            return this.notes;
        }

        @Override
        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof BlockState && super.equals(obj)) {
                BlockState other = (BlockState)obj;
                result = Objects.equals(this.blockType, other.blockType) && Objects.equals(this.name, other.name) && Objects.equals(this.notes, other.notes);
            }
            return result;
        }
    }
}

