/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.table.StyleTableCellRenderer;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayTableModel;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageRow;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageScheduleCellRenderer;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageScheduleGroup;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public abstract class CageTableModel
extends AbstractMultiDayTableModel {
    public CageTableModel(ScheduleEventGrid grid, Context context, ScheduleColours colours) {
        super(grid, context, colours);
    }

    @Override
    public int getRowCount() {
        return this.getGrid().getRows().size();
    }

    @Override
    public CageScheduleGrid getGrid() {
        return (CageScheduleGrid)super.getGrid();
    }

    public Object getValueAt(int column, int row) {
        CageRow cageRow = this.getGrid().getCageSchedule(row);
        CageRow result = column == 0 || cageRow.isSummary() ? cageRow : this.getEvent(column, row);
        return result;
    }

    @Override
    public PropertySet getEvent(int column, int row) {
        if (column == 0) {
            return null;
        }
        Schedule schedule = this.getSchedule(column, row);
        return schedule != null ? this.getGrid().getEvent(schedule, column - 1) : null;
    }

    @Override
    public int getRows(int column, int row) {
        int rowSpan = 1;
        CageScheduleGrid grid = this.getGrid();
        List<CageRow> rows = grid.getRows();
        CageRow cageRow = rows.get(row);
        if (cageRow.getSchedule() != null) {
            Entity entity = cageRow.getSchedule().getSchedule();
            for (int i = row + 1; i < rows.size() && rows.get(i).isSchedule(entity) && this.getEvent(column, i) == null; ++i) {
                ++rowSpan;
            }
        }
        return rowSpan;
    }

    @Override
    public Schedule getSchedule(int column, int row) {
        CageRow cageRow = this.getCageRow(row);
        return cageRow != null ? cageRow.getSchedule() : null;
    }

    public CageRow getCageRow(int row) {
        return this.getGrid().getCageSchedule(row);
    }

    public void toggle(int row) {
        CageRow cageRow = this.getCageRow(row);
        if (cageRow != null && cageRow.getGroup() != null) {
            CageScheduleGroup group = cageRow.getGroup();
            this.getGrid().expand(group, !group.isExpanded());
            this.fireTableDataChanged();
        }
    }

    @Override
    public ScheduleTableModel.State getState() {
        return new CageState(this);
    }

    @Override
    public void setState(ScheduleTableModel.State state) {
        super.setState(state);
        if (state instanceof CageState) {
            boolean changed = false;
            CageScheduleGrid grid = this.getGrid();
            CageState cageState = (CageState)state;
            for (CageState.Group groupState : cageState.groups) {
                CageScheduleGroup group = grid.getGroup(groupState.cageType);
                if (group == null) continue;
                changed |= grid.expand(group, groupState.expanded);
            }
            if (changed) {
                this.fireTableDataChanged();
            }
        }
    }

    public boolean isCageType(int row) {
        return this.getCageRow(row).isSummary();
    }

    @Override
    protected List<ScheduleTableModel.ScheduleRow> getRows(Reference scheduleRef) {
        ArrayList<ScheduleTableModel.ScheduleRow> result = new ArrayList<ScheduleTableModel.ScheduleRow>();
        int index = 0;
        for (CageRow row : this.getGrid().getRows()) {
            if (row.isSchedule(scheduleRef)) {
                result.add(new ScheduleTableModel.ScheduleRow(row.getSchedule(), index));
            } else if (!result.isEmpty()) break;
            ++index;
        }
        return result;
    }

    @Override
    protected TableColumnModel createColumnModel(ScheduleEventGrid grid) {
        DefaultTableColumnModel result = new DefaultTableColumnModel();
        Date start = grid.getStartDate();
        int modelIndex = 0;
        ScheduleTableModel.Column cageSchedule = new ScheduleTableModel.Column(modelIndex++, Messages.get((String)"workflow.scheduling.appointment.cage"));
        cageSchedule.setHeaderRenderer((TableCellRenderer)new StyleTableCellRenderer("Table.Header"));
        cageSchedule.setCellRenderer((TableCellRenderer)new CageScheduleCellRenderer());
        result.addColumn((TableColumn)cageSchedule);
        TableCellRenderer renderer = this.createEventRenderer();
        for (int i = 0; i < grid.getSlots(); ++i) {
            AbstractMultiDayTableModel.DateColumn column = new AbstractMultiDayTableModel.DateColumn(modelIndex++, DateRules.getDate((Date)start, (int)i, (DateUnits)DateUnits.DAYS));
            column.setCellRenderer(renderer);
            result.addColumn((TableColumn)column);
        }
        return result;
    }

    protected abstract TableCellRenderer createEventRenderer();

    protected static class CageState
    extends ScheduleTableModel.State {
        private List<Group> groups = new ArrayList<Group>();

        public CageState(CageTableModel model) {
            super(model);
            for (CageScheduleGroup group : model.getGrid().getGroups()) {
                this.groups.add(new Group(group));
            }
        }

        private static class Group {
            private final Reference cageType;
            private final boolean expanded;

            public Group(CageScheduleGroup group) {
                this.cageType = group.getCageType() != null ? group.getCageType().getObjectReference() : null;
                this.expanded = group.isExpanded();
            }
        }
    }
}

