/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.AppointmentTableHeaderRenderer;
import org.openvpms.web.workspace.workflow.appointment.AppointmentTableModel;
import org.openvpms.web.workspace.workflow.appointment.MultiScheduleTableCellRenderer;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

class MultiScheduleTableModel
extends AppointmentTableModel {
    private int rightStartTimeIndex;

    public MultiScheduleTableModel(AppointmentGrid grid, Context context, ScheduleColours colours) {
        super(grid, context, colours);
    }

    public Object getValueAt(int column, int row) {
        ScheduleTableModel.Column c = this.getColumn(column);
        int index = c.getModelIndex();
        Date result = index == 0 || index == this.rightStartTimeIndex ? this.getGrid().getStartTime(row) : this.getEvent(column, row);
        return result;
    }

    @Override
    protected TableColumnModel createColumnModel(ScheduleEventGrid grid) {
        DefaultTableColumnModel result = new DefaultTableColumnModel();
        List<Schedule> schedules = grid.getSchedules();
        int index = 0;
        String startTime = Messages.get((String)"workflow.scheduling.table.time");
        AppointmentTableModel.TimeColumnCellRenderer timeRenderer = new AppointmentTableModel.TimeColumnCellRenderer();
        TableColumn leftStartCol = this.createTimeColumn(index, startTime, timeRenderer);
        result.addColumn(leftStartCol);
        ++index;
        int percent = !schedules.isEmpty() ? 100 / schedules.size() : 0;
        MultiScheduleTableCellRenderer renderer = new MultiScheduleTableCellRenderer(this);
        for (Schedule schedule : schedules) {
            ScheduleTableModel.ScheduleColumn column = new ScheduleTableModel.ScheduleColumn(index++, schedule);
            column.setCellRenderer((TableCellRenderer)renderer);
            column.setHeaderRenderer(AppointmentTableHeaderRenderer.INSTANCE);
            if (percent != 0) {
                column.setWidth(new Extent(percent, 2));
            }
            result.addColumn((TableColumn)column);
        }
        this.rightStartTimeIndex = index;
        TableColumn rightStartCol = this.createTimeColumn(this.rightStartTimeIndex, startTime, timeRenderer);
        result.addColumn(rightStartCol);
        return result;
    }

    private TableColumn createTimeColumn(int modelIndex, String header, AppointmentTableModel.TimeColumnCellRenderer renderer) {
        ScheduleTableModel.ScheduleColumn column = new ScheduleTableModel.ScheduleColumn(modelIndex, header);
        column.setHeaderRenderer(AppointmentTableHeaderRenderer.INSTANCE);
        column.setCellRenderer((TableCellRenderer)renderer);
        column.setWidth(new Extent(100));
        return column;
    }
}

