/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import echopointng.table.TableCellRendererEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.table.StyleTableCellRenderer;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayTableModel;
import org.openvpms.web.workspace.workflow.appointment.MultiDayTableCellRenderer;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public class MultiDayTableModel
extends AbstractMultiDayTableModel {
    public MultiDayTableModel(AbstractMultiDayScheduleGrid grid, Context context, ScheduleColours colours) {
        super(grid, context, colours);
    }

    public Object getValueAt(int column, int row) {
        Schedule schedule = this.getSchedule(column, row);
        Schedule result = column == 0 ? schedule : this.getEvent(column, row);
        return result;
    }

    @Override
    public PropertySet getEvent(int column, int row) {
        if (column == 0) {
            return null;
        }
        Schedule schedule = this.getSchedule(column, row);
        return schedule != null ? this.getGrid().getEvent(schedule, column - 1) : null;
    }

    @Override
    public int getRows(int column, int row) {
        int rowSpan = 1;
        Entity entity = this.getSchedule(0, row).getSchedule();
        List<Schedule> schedules = this.getSchedules();
        for (int i = row + 1; i < schedules.size() && schedules.get(i).getSchedule().equals(entity) && this.getEvent(column, i) == null; ++i) {
            ++rowSpan;
        }
        return rowSpan;
    }

    @Override
    protected TableColumnModel createColumnModel(ScheduleEventGrid grid) {
        DefaultTableColumnModel result = new DefaultTableColumnModel();
        Date start = grid.getStartDate();
        int modelIndex = 0;
        ScheduleTableModel.Column scheduleColumn = new ScheduleTableModel.Column(modelIndex++, Messages.get((String)"workflow.scheduling.type"));
        scheduleColumn.setHeaderRenderer((TableCellRenderer)new StyleTableCellRenderer("Table.Header"));
        scheduleColumn.setCellRenderer((TableCellRenderer)new ScheduleColumnCellRenderer());
        result.addColumn((TableColumn)scheduleColumn);
        MultiDayTableCellRenderer renderer = new MultiDayTableCellRenderer(this);
        for (int i = 0; i < grid.getSlots(); ++i) {
            AbstractMultiDayTableModel.DateColumn column = new AbstractMultiDayTableModel.DateColumn(modelIndex++, DateRules.getDate((Date)start, (int)i, (DateUnits)DateUnits.DAYS));
            column.setCellRenderer((TableCellRenderer)renderer);
            result.addColumn((TableColumn)column);
        }
        return result;
    }

    private static class ScheduleColumnCellRenderer
    implements TableCellRendererEx {
        private ScheduleColumnCellRenderer() {
        }

        public XhtmlFragment getTableCellRendererContent(Table table, Object value, int column, int row) {
            return null;
        }

        public boolean isSelectionCausingCell(Table table, int column, int row) {
            return false;
        }

        public boolean isActionCausingCell(Table table, int column, int row) {
            return false;
        }

        public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
            Label result;
            Schedule schedule = (Schedule)value;
            Entity entity = schedule.getSchedule();
            if (entity != null) {
                Schedule next;
                MultiDayTableModel model = (MultiDayTableModel)table.getModel();
                Label label = LabelFactory.create(null, (String)"bold");
                label.setText(entity.getName());
                ++row;
                int span = 1;
                while (row < model.getRowCount() && (next = model.getSchedule(0, row)) != null && next.getSchedule().equals(entity)) {
                    ++span;
                    ++row;
                }
                if (span > 1) {
                    label.setLayoutData((LayoutData)TableFactory.rowSpan((int)span));
                }
                result = label;
            } else {
                result = new Label();
            }
            String styleName = schedule.getRenderEven() ? "ScheduleTable.Even" : "ScheduleTable.Odd";
            TableHelper.mergeStyle((Component)result, (String)styleName);
            return result;
        }
    }
}

