/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.joda.time.DateTime;
import org.openvpms.archetype.i18n.time.DateDurationFormatter;
import org.openvpms.archetype.i18n.time.DurationFormatter;
import org.openvpms.archetype.rules.workflow.Slot;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractTableBrowser;
import org.openvpms.web.component.im.query.IterableBackedResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.echo.factory.ContentPaneFactory;
import org.openvpms.web.echo.pane.ContentPane;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.workflow.appointment.FreeAppointmentSlotQuery;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleQuery;

class FreeAppointmentSlotBrowser
extends AbstractTableBrowser<Slot> {
    private final FreeAppointmentSlotQuery query;
    private static DurationFormatter formatter = DateDurationFormatter.create((boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);

    public FreeAppointmentSlotBrowser(FreeAppointmentSlotQuery query, LayoutContext layoutContext) {
        super((IMTableModel)new SlotTableModel(), layoutContext);
        this.query = query;
        query.setListener(new ScheduleQuery.ScheduleQueryListener(){

            @Override
            public void now() {
            }

            public void query() {
                FreeAppointmentSlotBrowser.this.onQuery();
            }
        });
    }

    public Entity getScheduleView() {
        return this.query.getScheduleView();
    }

    public Entity getSchedule(Slot slot) {
        for (Entity schedule : this.query.getViewSchedules()) {
            if (slot.getSchedule() != schedule.getId()) continue;
            return schedule;
        }
        return null;
    }

    public void query() {
        Iterable iterable = this.query::query;
        ((SlotTableModel)this.getTableModel()).setSchedules(this.query.getSelectedSchedules());
        IterableBackedResultSet set = new IterableBackedResultSet(iterable, 20);
        Component component = this.getComponent();
        this.doLayout(component, this.hasResults((ResultSet)set));
        PagedIMTable table = this.getTable();
        table.setResultSet((ResultSet)set);
        this.setFocusOnResults();
    }

    protected void doLayout() {
        ContentPane container = ContentPaneFactory.create();
        this.setComponent((Component)container);
    }

    protected void doLayout(Component container) {
    }

    private void onQuery() {
        this.query();
        this.notifyBrowserListeners();
    }

    private static class SlotTableModel
    extends AbstractIMTableModel<Slot> {
        private Map<Long, String> names = Collections.emptyMap();
        private static final int SCHEDULE = 0;
        private static final int DATE = 1;
        private static final int TIME = 2;
        private static final int DURATION = 3;

        public SlotTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(SlotTableModel.createTableColumn((int)0, (String)"workflow.scheduling.query.schedule"));
            model.addColumn(SlotTableModel.createTableColumn((int)1, (String)"table.act.date"));
            model.addColumn(SlotTableModel.createTableColumn((int)2, (String)"table.act.time"));
            model.addColumn(SlotTableModel.createTableColumn((int)3, (String)"workflow.scheduling.appointment.find.duration"));
            this.setTableColumnModel((TableColumnModel)model);
        }

        public void setSchedules(List<Entity> schedules) {
            this.names = new HashMap<Long, String>();
            for (Entity schedule : schedules) {
                this.names.put(schedule.getId(), schedule.getName());
            }
        }

        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            return null;
        }

        protected Object getValue(Slot slot, TableColumn column, int row) {
            String result = null;
            Date startTime = slot.getStartTime();
            switch (column.getModelIndex()) {
                case 0: {
                    result = this.names.get(slot.getSchedule());
                    break;
                }
                case 1: {
                    DateFormat format = this.getDateFormat(startTime);
                    result = format.format(startTime);
                    break;
                }
                case 2: {
                    result = DateFormatter.formatTime((Date)startTime, (boolean)false);
                    break;
                }
                case 3: {
                    result = formatter.format(startTime, slot.getEndTime());
                }
            }
            return result;
        }

        private DateFormat getDateFormat(Date startTime) {
            DateFormat format = new DateTime((Object)startTime).getYear() == new DateTime().getYear() ? DateFormatter.getDayMonthDateFormat() : DateFormatter.getFullDateFormat();
            return format;
        }
    }
}

