/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import echopointng.table.TableCellRendererEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Table;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public abstract class AppointmentTableModel
extends ScheduleTableModel {
    protected static final int START_TIME_INDEX = 0;

    public AppointmentTableModel(AppointmentGrid grid, Context context, ScheduleColours colours) {
        super(grid, context, true, colours);
    }

    public int getHour(int row) {
        return this.getGrid().getHour(row);
    }

    @Override
    public AppointmentGrid getGrid() {
        return (AppointmentGrid)super.getGrid();
    }

    @Override
    public int getSlot(Schedule schedule, Reference eventRef) {
        PropertySet event = schedule.getEvent(eventRef);
        if (event != null) {
            return this.getGrid().getSlot(event.getDate("act.startTime"));
        }
        return -1;
    }

    @Override
    public String getStatus(PropertySet event) {
        String status = null;
        String code = event.getString("act.status");
        if ("CHECKED_IN".equals(code)) {
            Date arrival = event.getDate("arrivalTime");
            if (arrival != null) {
                String diff = DateFormatter.formatTimeDiff((Date)arrival, (Date)new Date());
                status = Messages.format((String)"workflow.scheduling.table.waiting", (Object[])new Object[]{diff});
            }
        } else {
            status = event.getString("act.statusName");
        }
        return status;
    }

    public boolean showRoster() {
        return this.getGrid().showRoster();
    }

    public void setShowRoster(boolean show) {
        this.getGrid().setShowRoster(show);
        this.fireTableDataChanged();
    }

    protected class TimeColumnCellRenderer
    implements TableCellRendererEx {
        protected TimeColumnCellRenderer() {
        }

        public XhtmlFragment getTableCellRendererContent(Table table, Object value, int column, int row) {
            return null;
        }

        public boolean isSelectionCausingCell(Table table, int column, int row) {
            return false;
        }

        public boolean isActionCausingCell(Table table, int column, int row) {
            return false;
        }

        public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
            Date date = (Date)value;
            String text = DateFormatter.formatTime((Date)date, (boolean)false);
            Label label = LabelFactory.create();
            label.setText(text);
            int hour = AppointmentTableModel.this.getHour(row);
            String styleName = hour % 2 == 0 ? "ScheduleTable.Even" : "ScheduleTable.Odd";
            label.setStyleName(styleName);
            return label;
        }
    }
}

