/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.Slot;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;

class AppointmentGridView
extends AbstractAppointmentGrid {
    private final AppointmentGrid grid;
    private final List<Slot> slots;
    private int startSlot;

    public AppointmentGridView(AppointmentGrid grid, int startMins, int endMins, AppointmentRules rules, RosterService rosterService) {
        super(grid.getScheduleView(), grid.getStartDate(), startMins, endMins, rules, rosterService);
        int endSlot;
        this.grid = grid;
        this.startSlot = grid.getSlot(this.getSlotTimeForMinutes(startMins));
        if (this.startSlot == -1) {
            this.startSlot = grid.getSlots() > 0 ? grid.getSlots() - 1 : 0;
        }
        if ((endSlot = grid.getSlot(this.getSlotTimeForMinutes(endMins))) >= grid.getSlots()) {
            endSlot = grid.getSlots() - 1;
        }
        this.slots = grid.getSlotTimes().subList(this.startSlot, endSlot + 1);
        this.setSlotSize(grid.getSlotSize());
    }

    @Override
    public List<Schedule> getSchedules() {
        return this.grid.getSchedules();
    }

    @Override
    public PropertySet getEvent(Schedule schedule, int slot) {
        PropertySet result = null;
        if (slot <= this.getSlots() && (result = this.grid.getEvent(schedule, this.startSlot + slot)) == null && slot == 0) {
            Date start = this.getStartTime(schedule, slot);
            Date end = this.getEndTime(schedule, slot);
            result = schedule.getIntersectingEvent(start, end, this.getSlotSize());
        }
        return result;
    }

    @Override
    public int getSlots(PropertySet event, Schedule schedule, int slot) {
        return this.grid.getSlots(event, schedule, this.startSlot + slot);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    public Date getStartTime(int slot) {
        return this.grid.getStartTime(this.startSlot + slot);
    }

    @Override
    public Date getEndTime(int slot) {
        return this.grid.getEndTime(this.startSlot + slot);
    }

    @Override
    public Date getStartTime(Schedule schedule, int slot) {
        return this.grid.getStartTime(schedule, this.startSlot + slot);
    }

    @Override
    public int getHour(int slot) {
        return this.grid.getHour(this.startSlot + slot);
    }

    @Override
    public int getSlot(Date time) {
        int slot = this.grid.getSlot(time);
        return slot >= this.startSlot ? slot - this.startSlot : -1;
    }

    @Override
    public ScheduleEventGrid.Availability getAvailability(Schedule schedule, int slot) {
        return this.grid.getAvailability(schedule, this.startSlot + slot);
    }

    @Override
    public List<Slot> getSlotTimes() {
        return this.slots;
    }

    @Override
    public void setShowRoster(boolean show) {
        this.grid.setShowRoster(show);
    }

    @Override
    public boolean showRoster() {
        return this.grid.showRoster();
    }
}

