/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import echopointng.layout.TableLayoutDataEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.Date;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.layout.RowLayoutData;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentTableCellRender;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayTableModel;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public abstract class AbstractMultiDayTableCellRenderer
extends AbstractAppointmentTableCellRender {
    public AbstractMultiDayTableCellRenderer(AbstractMultiDayTableModel model) {
        super(model);
    }

    @Override
    protected AbstractMultiDayTableModel getModel() {
        return (AbstractMultiDayTableModel)super.getModel();
    }

    @Override
    protected Component getComponent(Table table, Object value, int column, int row) {
        Component result = super.getComponent(table, value, column, row);
        if (result == null) {
            result = this.getFreeSlot(column, row);
        }
        return result;
    }

    public XhtmlFragment getTableCellRendererContent(Table table, Object value, int column, int row) {
        XhtmlFragment result = TableHelper.createFragment((Object)value);
        ScheduleTableModel model = (ScheduleTableModel)table.getModel();
        ScheduleEventGrid.Availability avail = model.getAvailability(column, row);
        String style = this.getStyle(avail, model, row);
        TableLayoutDataEx layout = TableHelper.getTableLayoutDataEx((String)style);
        if (layout != null && avail == ScheduleEventGrid.Availability.UNAVAILABLE) {
            Schedule schedule = model.getSchedule(column, row);
            int span = model.getGrid().getUnavailableSlots(schedule, row);
            layout.setRowSpan(span);
        }
        result.setLayoutData((LayoutData)layout);
        return result;
    }

    @Override
    protected String getFreeStyle(ScheduleTableModel model, int row) {
        Schedule schedule = model.getSchedule(0, row);
        return schedule.getRenderEven() ? "ScheduleTable.Even" : "ScheduleTable.Odd";
    }

    @Override
    protected Component getEvent(Table table, PropertySet event, int column, int row) {
        int span;
        Component result = super.getEvent(table, event, column, row);
        Label next = null;
        Label previous = null;
        Date startTime = event.getDate("act.startTime");
        int slot = column - 1;
        AbstractMultiDayTableModel model = this.getModel();
        AbstractMultiDayScheduleGrid grid = model.getGrid();
        if (DateRules.compareDates((Date)startTime, (Date)grid.getDate(slot)) < 0) {
            previous = LabelFactory.create(null, (String)"navigation.previous");
        }
        if ((span = grid.getSlots(event, column - 1)) > 1 && column + span > model.getColumnCount()) {
            next = LabelFactory.create(null, (String)"navigation.next");
            RowLayoutData newValue = new RowLayoutData();
            newValue.setAlignment(Alignment.ALIGN_RIGHT);
            newValue.setWidth(Styles.FULL_WIDTH);
            next.setLayoutData((LayoutData)newValue);
        }
        if (previous != null || next != null) {
            Row container = RowFactory.create();
            if (previous != null) {
                container.add((Component)previous);
            }
            container.add(result);
            if (next != null) {
                container.add((Component)next);
            }
            result = container;
        }
        if (span > 1) {
            result.setLayoutData(TableFactory.columnSpan((int)span));
        }
        this.styleEvent(event, result, table);
        return result;
    }

    protected Component getFreeSlot(int column, int row) {
        AbstractMultiDayTableModel model = this.getModel();
        Label result = LabelFactory.create();
        String style = this.getFreeStyle(model, row);
        TableLayoutDataEx layout = TableHelper.getTableLayoutDataEx((String)style);
        layout.setRowSpan(model.getRows(column, row));
        result.setLayoutData((LayoutData)layout);
        return result;
    }

    @Override
    protected boolean canHighlightCell(int column, int row, Object value) {
        boolean highlight = false;
        if (this.getModel().isSelected(column, row) && value instanceof PropertySet) {
            highlight = true;
        }
        return highlight;
    }
}

