/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.SoftRefIMObjectCache;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;

public abstract class AbstractMultiDayScheduleGrid
extends AbstractScheduleEventGrid {
    private final int days;
    private static final int MINUTES_PER_DAY = 1440;

    public AbstractMultiDayScheduleGrid(Entity scheduleView, Date date, int days, Map<Entity, ScheduleEvents> events, AppointmentRules rules) {
        super(scheduleView, date, DateRules.getDate((Date)date, (int)(days - 1), (DateUnits)DateUnits.DAYS), rules);
        this.days = days;
        this.setEvents(events);
    }

    @Override
    public int getSlots() {
        return this.days;
    }

    @Override
    public int getSlotSize() {
        return 1440;
    }

    @Override
    public PropertySet getEvent(Schedule schedule, int slot) {
        return this.getEvent(schedule, slot, true);
    }

    public PropertySet getEvent(Schedule schedule, int slot, boolean includeBlockingEvents) {
        Date time;
        PropertySet result = null;
        if (slot < this.getSlots() && (result = schedule.getEvent(time = this.getStartTime(schedule, slot), 1440, includeBlockingEvents)) == null) {
            result = schedule.getIntersectingEvent(time, time, 1440, includeBlockingEvents);
        }
        return result;
    }

    @Override
    public Date getStartTime(Schedule schedule, int slot) {
        Date date = DateRules.getDate((Date)this.getStartDate(), (int)slot, (DateUnits)DateUnits.DAYS);
        return DateRules.getDate((Date)date, (int)schedule.getStartMins(), (DateUnits)DateUnits.MINUTES);
    }

    @Override
    public Date getEndTime(Schedule schedule, int slot) {
        Date date = DateRules.getDate((Date)this.getStartDate(), (int)slot, (DateUnits)DateUnits.DAYS);
        if (schedule.getEndMins() == 1440) {
            return DateRules.getDate((Date)date, (int)1, (DateUnits)DateUnits.DAYS);
        }
        return DateRules.getDate((Date)date, (int)schedule.getEndMins(), (DateUnits)DateUnits.MINUTES);
    }

    @Override
    public ScheduleEventGrid.Availability getAvailability(Schedule schedule, int slot) {
        PropertySet event = this.getEvent(schedule, slot, false);
        return event != null ? ScheduleEventGrid.Availability.BUSY : ScheduleEventGrid.Availability.FREE;
    }

    @Override
    public int getUnavailableSlots(Schedule schedule, int slot) {
        return 0;
    }

    @Override
    public int getSlot(Date time) {
        return Days.daysBetween((ReadableInstant)new DateTime((Object)this.getStartDate()), (ReadableInstant)new DateTime((Object)time)).getDays();
    }

    public int getSlots(PropertySet event, int slot) {
        DateTime endTime = new DateTime((Object)event.getDate("act.endTime"));
        int endSlot = Days.daysBetween((ReadableInstant)new DateTime((Object)this.getStartDate()), (ReadableInstant)endTime).getDays();
        if (endTime.getHourOfDay() > 0 || endTime.getMinuteOfHour() > 0) {
            ++endSlot;
        }
        return endSlot - slot;
    }

    public Date getDate(int slot) {
        return DateRules.getDate((Date)this.getStartDate(), (int)slot, (DateUnits)DateUnits.DAYS);
    }

    protected void setEvents(Map<Entity, ScheduleEvents> events) {
        ArrayList<Schedule> schedules = new ArrayList<Schedule>();
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        SoftRefIMObjectCache cageTypes = new SoftRefIMObjectCache((ArchetypeService)service);
        int index = -1;
        Entity last = null;
        AppointmentRules rules = this.getAppointmentRules();
        for (Entity entity : events.keySet()) {
            IMObjectBean bean = service.getBean((IMObject)entity);
            Entity cageType = (Entity)cageTypes.get(bean.getTargetRef("cageType"));
            Schedule schedule = new Schedule(entity, cageType, 0, 1440, 1440, Collections.emptyList(), rules);
            if (!Objects.equals(last, entity)) {
                ++index;
            }
            last = entity;
            schedule.setRenderEven(index % 2 == 0);
            schedules.add(schedule);
        }
        this.setSchedules(schedules);
        for (Map.Entry entry : events.entrySet()) {
            Entity schedule = (Entity)entry.getKey();
            List sets = ((ScheduleEvents)entry.getValue()).getEvents();
            for (PropertySet set : sets) {
                this.addEvent(schedule, set);
            }
        }
    }

    @Override
    protected void addEvent(Entity schedule, PropertySet event) {
        int index = -1;
        boolean found = false;
        Schedule row = null;
        Schedule match = null;
        List<Schedule> rows = this.getSchedules();
        IMObjectReference eventRef = event.getReference("act.objectReference");
        for (int i = 0; i < rows.size(); ++i) {
            row = rows.get(i);
            if (!row.getSchedule().equals(schedule)) continue;
            if (row.indexOf((Reference)eventRef) != -1) {
                return;
            }
            if (row.hasIntersectingEvent(event, false, 1440)) {
                match = row;
                index = i;
                continue;
            }
            found = true;
            break;
        }
        if (!found) {
            row = new Schedule(match, false, this.getAppointmentRules());
            rows.add(index + 1, row);
        }
        row.addEvent(event);
    }
}

