/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditor;
import org.openvpms.web.workspace.workflow.appointment.OverlappingCalendarEventDialog;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCalendarEventEditDialog
extends EditDialog {
    private Date startTime;
    private Date endTime;
    private RepeatExpression expression;
    private RepeatCondition condition;
    private boolean alwaysCheckOverlap = false;
    private static final Logger log = LoggerFactory.getLogger(AbstractCalendarEventEditDialog.class);

    public AbstractCalendarEventEditDialog(AbstractCalendarEventEditor editor, Context context) {
        super((IMObjectEditor)editor, context);
        this.getState();
    }

    public AbstractCalendarEventEditor getEditor() {
        return (AbstractCalendarEventEditor)super.getEditor();
    }

    public void setAlwaysCheckOverlap(boolean checkOverlap) {
        this.alwaysCheckOverlap = checkOverlap;
    }

    protected void onApply() {
        if (this.noTimeCheckRequired()) {
            this.save();
        } else if (this.checkEventTimes(false) && this.save()) {
            this.getState();
        }
    }

    protected void onOK() {
        if (this.noTimeCheckRequired()) {
            super.onOK();
        } else if (this.checkEventTimes(true)) {
            super.onOK();
        }
    }

    protected Act getEvent() {
        return this.getEditor().getObject();
    }

    protected void getState() {
        Act event = this.getEvent();
        this.startTime = event.getActivityStartTime();
        this.endTime = event.getActivityEndTime();
        ScheduleEventSeries series = this.getEditor().getSeries();
        if (series != null) {
            this.expression = series.getExpression();
            this.condition = series.getCondition();
        } else {
            this.expression = null;
            this.condition = null;
        }
    }

    protected boolean checkEventTimes(boolean close) {
        DefaultValidator validator;
        AbstractCalendarEventEditor editor = this.getEditor();
        boolean result = editor.validate((Validator)(validator = new DefaultValidator()));
        if (result) {
            List<Times> times = editor.getEventTimes();
            result = times != null && this.checkEventTimes(times, close);
        } else {
            ValidationHelper.showError((Validator)validator);
        }
        return result;
    }

    protected abstract boolean checkEventTimes(List<Times> var1, boolean var2);

    protected boolean noTimeCheckRequired() {
        Act event = this.getEvent();
        return !this.alwaysCheckOverlap && !event.isNew() && !this.timeSeriesModified();
    }

    protected boolean timeSeriesModified() {
        ScheduleEventSeries series = this.getEditor().getSeries();
        Act act = this.getEvent();
        RepeatExpression otherExpression = series != null ? series.getExpression() : null;
        RepeatCondition otherCondition = series != null ? series.getCondition() : null;
        return DateRules.compareTo((Date)this.startTime, (Date)act.getActivityStartTime()) != 0 || DateRules.compareTo((Date)this.endTime, (Date)act.getActivityEndTime()) != 0 || !Objects.equals(this.expression, otherExpression) || !Objects.equals(this.condition, otherCondition);
    }

    protected void displayOverlapError(Times overlap) {
        Act event = this.getEvent();
        String displayName = DescriptorHelper.getDisplayName((IMObject)event, (ArchetypeService)ServiceHelper.getArchetypeService());
        String title = Messages.format((String)"workflow.scheduling.nodoubleschedule.title", (Object[])new Object[]{displayName});
        String message = Messages.format((String)"workflow.scheduling.nodoubleschedule.message", (Object[])new Object[]{displayName});
        OverlappingCalendarEventDialog dialog = new OverlappingCalendarEventDialog(title, message, overlap, PopupDialog.OK);
        dialog.show();
        log.error("Overlap: reference=" + event.getObjectReference() + ", from=" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(event.getActivityStartTime()) + ", to=" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(event.getActivityEndTime()) + " overlaps reference=" + overlap.getReference() + ", from=" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(overlap.getStartTime()) + ", to=" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(overlap.getEndTime()));
    }
}

