/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import echopointng.LabelEx;
import echopointng.layout.TableLayoutDataEx;
import java.util.Date;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.workflow.appointment.sms.AppointmentSMSViewerDialog;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableCellRenderer;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

public abstract class AbstractAppointmentTableCellRender
extends ScheduleTableCellRenderer {
    public AbstractAppointmentTableCellRender(ScheduleTableModel model) {
        super(model);
    }

    public static Label createReminderIcon(Date reminderSent, String reminderError) {
        String style;
        String tooltip = null;
        if (!StringUtils.isEmpty((CharSequence)reminderError)) {
            style = "AppointmentReminder.error";
        } else if (reminderSent != null) {
            style = "AppointmentReminder.sent";
            tooltip = Messages.format((String)"workflow.scheduling.appointment.table.reminded", (Object[])new Object[]{DateFormatter.formatDateTimeAbbrev((Date)reminderSent)});
        } else {
            style = "AppointmentReminder.unsent";
        }
        Label label = LabelFactory.create(null, (String)style);
        label.setToolTipText(tooltip);
        return label;
    }

    public static Component addAppointmentIcons(Component component, final PropertySet event) {
        boolean hasReminder;
        boolean sendReminder = event.exists("sendReminder") && event.getBoolean("sendReminder");
        Date reminderSent = event.exists("reminderSent") ? event.getDate("reminderSent") : null;
        String reminderError = event.exists("reminderError") ? event.getString("reminderError") : null;
        Date confirmedTime = event.exists("confirmedTime") ? event.getDate("confirmedTime") : null;
        boolean onlineBooking = event.exists("onlineBooking") && event.getBoolean("onlineBooking");
        String smsStatus = event.exists("smsStatus") ? event.getString("smsStatus") : null;
        boolean bl = hasReminder = sendReminder || reminderSent != null || reminderError != null;
        if (hasReminder || smsStatus != null || confirmedTime != null || onlineBooking) {
            if (!(component instanceof Row)) {
                component = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{component});
            }
            if (hasReminder) {
                Label reminder = AbstractAppointmentTableCellRender.createReminderIcon(reminderSent, reminderError);
                reminder.setLayoutData((LayoutData)RowFactory.layout((Alignment)new Alignment(5, 6), (Extent)Styles.FULL_WIDTH));
                component.add((Component)reminder);
            }
            if (smsStatus != null) {
                final Button sms = ButtonFactory.create();
                if ("RECEIVED".equals(smsStatus)) {
                    sms.setStyleName("Appointment.SMS.Unread");
                } else {
                    sms.setStyleName("Appointment.SMS.Default");
                }
                sms.setToolTipText(Messages.get((String)"workflow.scheduling.appointment.table.viewsms"));
                sms.setLayoutData((LayoutData)RowFactory.layout((Alignment)new Alignment(5, 6), (Extent)Styles.FULL_WIDTH));
                component.add((Component)sms);
                sms.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                    public void onAction(ActionEvent actionEvent) {
                        IMObjectReference reference = event.getReference("act.objectReference");
                        AppointmentSMSViewerDialog dialog = AppointmentSMSViewerDialog.create((Reference)reference);
                        if (dialog != null) {
                            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                                public void onClose(WindowPaneEvent event) {
                                    sms.setStyleName("Appointment.SMS.Default");
                                }
                            });
                            dialog.show();
                        }
                    }
                });
                component.add((Component)sms);
            }
            if (confirmedTime != null) {
                LabelEx confirmed = new LabelEx();
                confirmed.setStyleName("Appointment.Confirmed");
                confirmed.setLayoutData((LayoutData)RowFactory.layout((Alignment)new Alignment(5, 6), (Extent)Styles.FULL_WIDTH));
                confirmed.setToolTipText(Messages.format((String)"workflow.scheduling.appointment.table.confirmed", (Object[])new Object[]{DateFormatter.formatDateTimeAbbrev((Date)confirmedTime)}));
                component.add((Component)confirmed);
            }
            if (onlineBooking) {
                Label booking = LabelFactory.create(null, (String)"Appointment.OnlineBooking");
                booking.setLayoutData((LayoutData)RowFactory.layout((Alignment)new Alignment(5, 6), (Extent)Styles.FULL_WIDTH));
                component.add((Component)booking);
            }
        }
        return component;
    }

    @Override
    protected Component getEvent(Table table, PropertySet event, int column, int row) {
        Component result = Schedule.isBlockingEvent(event) ? this.getBlock(event) : this.getAppointment(event);
        return result;
    }

    protected Component createLabelWithNotes(String text, String notes, PropertySet event) {
        Component result = this.createLabelWithNotes(text, notes);
        return AbstractAppointmentTableCellRender.addAppointmentIcons(result, event);
    }

    @Override
    protected TableLayoutDataEx getEventLayoutData(PropertySet event, ScheduleTableModel.Highlight highlight) {
        TableLayoutDataEx result = null;
        if (Schedule.isBlockingEvent(event)) {
            IMObjectReference reference = event.getReference("scheduleType.objectReference");
            Color colour = this.getColour((Reference)reference);
            if (colour != null) {
                result = new TableLayoutDataEx();
                result.setBackground(colour);
            }
        } else {
            result = super.getEventLayoutData(event, highlight);
        }
        return result;
    }

    private Component getAppointment(PropertySet event) {
        String text = this.evaluate(event);
        if (text == null) {
            String customer = event.getString("customer.name");
            String patient = event.getString("patient.name");
            String status = this.getModel().getStatus(event);
            String reason = event.getString("act.reasonName");
            if (reason == null) {
                reason = event.getString("act.reason");
            }
            if (reason == null) {
                reason = Messages.get((String)"workflow.scheduling.appointment.table.noreason");
            }
            if (patient == null) {
                if (customer == null) {
                    customer = Messages.get((String)"workflow.scheduling.appointment.table.nocustomer");
                }
                text = Messages.format((String)"workflow.scheduling.appointment.table.customer", (Object[])new Object[]{customer, reason, status});
            } else {
                text = Messages.format((String)"workflow.scheduling.appointment.table.customerpatient", (Object[])new Object[]{customer, patient, reason, status});
            }
        }
        String notes = event.getString("notes");
        Component result = this.createLabelWithNotes(text, notes, event);
        return result;
    }

    private Component getBlock(PropertySet event) {
        String text = event.getString("act.name");
        if (text == null) {
            text = event.getString("scheduleType.name");
        }
        String notes = event.getString("notes");
        return this.createLabelWithNotes(text, notes);
    }
}

