/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.query.AbstractIMObjectQuery;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;

public abstract class ScheduleTypeQuery
extends AbstractIMObjectQuery<Entity> {
    private final String scheduleTypesNode;
    private final Context context;
    private Entity schedule;

    public ScheduleTypeQuery(String[] shortNames, Entity schedule, String scheduleTypesNode, Context context) {
        super(shortNames, Entity.class);
        this.schedule = schedule;
        this.scheduleTypesNode = scheduleTypesNode;
        this.context = context;
        QueryFactory.initialise((Query)this);
    }

    public void setSchedule(Entity schedule) {
        this.schedule = schedule;
    }

    public ResultSet<Entity> query(SortConstraint[] sort) {
        ResultSet result;
        this.getComponent();
        if (this.schedule == null) {
            result = super.query(sort);
        } else {
            List<Entity> objects = this.filterForSchedule();
            result = new IMObjectListResultSet(objects, this.getMaxResults());
            if (sort != null) {
                result.sort(sort);
            }
        }
        return result;
    }

    public boolean selects(Reference reference) {
        boolean result;
        if (this.schedule == null) {
            result = super.selects(reference);
        } else {
            IMObjectBean bean = this.getService().getBean((IMObject)this.schedule);
            result = bean.getTargetRefs(this.scheduleTypesNode).contains(reference);
        }
        return result;
    }

    private List<Entity> filterForSchedule() {
        List types = this.getScheduleTypes(this.schedule);
        String name = this.getValue();
        types = IMObjectHelper.findByName((String)name, types);
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Entity type : types) {
            if (!type.isActive()) continue;
            result.add(type);
        }
        return result;
    }

    private List<Entity> getScheduleTypes(Entity schedule) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        IMObjectBean bean = this.getService().getBean((IMObject)schedule);
        List relationships = bean.getValues(this.scheduleTypesNode, Relationship.class);
        for (Relationship relationship : relationships) {
            IMObject type = IMObjectHelper.getObject((Reference)relationship.getTarget(), (Context)this.context);
            if (type == null) continue;
            result.add((Entity)type);
        }
        return result;
    }
}

